/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceComparator;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;

public class DevicePickerListModel
extends AbstractListModel {
    private final List<DevicePickerEntry> myEntries = Lists.newArrayList();
    private boolean myShowSerialNumbers;

    public void reset(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avds) {
        this.clear();
        List<AndroidDevice> connected = DevicePickerListModel.wrapConnectedDevices(connectedDevices, avds);
        this.addEntries(connected, DevicePickerListModel.getLaunchableDevices(avds, DevicePickerListModel.getRunningAvds(connectedDevices)));
        this.myShowSerialNumbers = DevicePickerListModel.shouldShowSerials(connected);
    }

    private static List<AndroidDevice> wrapConnectedDevices(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avdInfos) {
        ArrayList devices = Lists.newArrayList();
        for (IDevice device : connectedDevices) {
            devices.add(new ConnectedAndroidDevice(device, avdInfos));
        }
        return devices;
    }

    @NotNull
    private static List<AndroidDevice> getLaunchableDevices(@NotNull List<AvdInfo> avds, @NotNull Set<String> runningAvds) {
        ArrayList launchable = Lists.newArrayList();
        for (AvdInfo avdInfo : avds) {
            if (runningAvds.contains(avdInfo.getName())) continue;
            launchable.add(new LaunchableAndroidDevice(avdInfo));
        }
        return launchable;
    }

    private static Set<String> getRunningAvds(@NotNull List<IDevice> connectedDevices) {
        HashSet runningAvdNames = Sets.newHashSet();
        for (IDevice device : connectedDevices) {
            String avdName;
            if (!device.isEmulator() || (avdName = device.getAvdName()) == null) continue;
            runningAvdNames.add(avdName);
        }
        return runningAvdNames;
    }

    private void addEntries(@NotNull List<AndroidDevice> connected, @NotNull List<AndroidDevice> launchable) {
        int size;
        AndroidDeviceComparator comparator = new AndroidDeviceComparator();
        Collections.sort(connected, comparator);
        Collections.sort(launchable, comparator);
        this.myEntries.add(DevicePickerEntry.CONNECTED_DEVICES_MARKER);
        if (!connected.isEmpty()) {
            for (AndroidDevice device : connected) {
                this.myEntries.add(DevicePickerEntry.create(device));
            }
        } else {
            this.myEntries.add(DevicePickerEntry.NONE);
        }
        if (!launchable.isEmpty()) {
            this.myEntries.add(DevicePickerEntry.LAUNCHABLE_DEVICES_MARKER);
            for (AndroidDevice device : launchable) {
                this.myEntries.add(DevicePickerEntry.create(device));
            }
        }
        if ((size = this.myEntries.size()) > 0) {
            this.fireIntervalAdded(this, 0, size - 1);
        }
    }

    private void clear() {
        int oldSize = this.getSize();
        this.myEntries.clear();
        if (oldSize > 0) {
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    private static boolean shouldShowSerials(@NotNull List<AndroidDevice> connectedDevices) {
        HashSet myModelNames = Sets.newHashSet();
        for (AndroidDevice device : connectedDevices) {
            if (device.isVirtual()) continue;
            String name = device.getName();
            if (myModelNames.contains(name)) {
                return true;
            }
            myModelNames.add(name);
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.myEntries.get(index);
    }

    @NotNull
    public List<DevicePickerEntry> getItems() {
        return this.myEntries;
    }

    public boolean shouldShowSerialNumbers() {
        return this.myShowSerialNumbers;
    }
}

