/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSessionInfo {
    public static final Key<AndroidSessionInfo> KEY = new Key("KEY");
    public static final Key<Client> ANDROID_DEBUG_CLIENT = new Key("ANDROID_DEBUG_CLIENT");
    public static final Key<AndroidVersion> ANDROID_DEVICE_API_LEVEL = new Key("ANDROID_DEVICE_API_LEVEL");
    @NotNull
    private final ProcessHandler myProcessHandler;
    private final RunContentDescriptor myDescriptor;
    private final String myExecutorId;
    private final int myRunConfigId;
    private final boolean myInstantRun;

    public AndroidSessionInfo(@NotNull ProcessHandler processHandler, @NotNull RunContentDescriptor descriptor, int runConfigId, @NotNull String executorId, boolean instantRunEnabled) {
        this.myProcessHandler = processHandler;
        this.myDescriptor = descriptor;
        this.myRunConfigId = runConfigId;
        this.myExecutorId = executorId;
        this.myInstantRun = instantRunEnabled;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @NotNull
    public RunContentDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    public boolean isInstantRun() {
        return this.myInstantRun;
    }

    @Nullable
    public List<IDevice> getDevices() {
        if (this.myProcessHandler instanceof AndroidProcessHandler) {
            return ((AndroidProcessHandler)this.myProcessHandler).getDevices();
        }
        Client client = (Client)this.myProcessHandler.getUserData(ANDROID_DEBUG_CLIENT);
        if (client != null) {
            return Collections.singletonList(client.getDevice());
        }
        return null;
    }

    public int getRunConfigurationId() {
        return this.myRunConfigId;
    }

    @Nullable
    public static AndroidSessionInfo findOldSession(@NotNull Project project, @Nullable Executor executor, int currentID) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            AndroidSessionInfo info;
            if (handler.isProcessTerminated() || handler.isProcessTerminating() || (info = (AndroidSessionInfo)handler.getUserData(KEY)) == null || currentID != info.getRunConfigurationId() || executor != null && !executor.getId().equals(info.getExecutorId())) continue;
            return info;
        }
        return null;
    }
}

