/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.PsiProjectListener;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public class ResourceFolderRegistry {
    private static final Object DIR_MAP_LOCK = new Object();
    private static final Map<VirtualFile, ResourceFolderRepository> ourDirMap = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            for (Map.Entry<VirtualFile, ResourceFolderRepository> entry : ourDirMap.entrySet()) {
                VirtualFile dir = entry.getKey();
                ResourceFolderRepository repository = entry.getValue();
                Project project = repository.getFacet().getModule().getProject();
                PsiProjectListener.removeRoot(project, dir, repository);
            }
            ourDirMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ResourceFolderRepository get(@NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            ResourceFolderRepository repository = ourDirMap.get(dir);
            if (repository == null) {
                Project project = facet.getModule().getProject();
                repository = ResourceFolderRepository.create(facet, dir, null);
                ResourceFolderRegistry.putRepositoryInCache(project, dir, repository);
            }
            return repository;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putRepositoryInCache(@NotNull Project project, final @NotNull VirtualFile dir, @NotNull ResourceFolderRepository repository) {
        Object object = DIR_MAP_LOCK;
        synchronized (object) {
            PsiProjectListener.addRoot(project, dir, repository);
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dispose() {
                    Object object = DIR_MAP_LOCK;
                    synchronized (object) {
                        ResourceFolderRepository repository = (ResourceFolderRepository)((Object)ourDirMap.remove(dir));
                        if (repository != null) {
                            repository.dispose();
                        }
                    }
                }
            });
            ourDirMap.put(dir, repository);
        }
    }

    private static void filterOutCached(Map<VirtualFile, AndroidFacet> resDirectories) {
        resDirectories.keySet().removeAll(ourDirMap.keySet());
    }

    @NotNull
    static Map<VirtualFile, AndroidFacet> getResourceDirectoriesForFacets(@NotNull List<AndroidFacet> facets) {
        HashMap resDirectories = Maps.newHashMap();
        for (AndroidFacet facet : facets) {
            for (VirtualFile resourceDir : facet.getAllResourceDirectories()) {
                if (resDirectories.containsKey(resourceDir)) continue;
                resDirectories.put(resourceDir, facet);
            }
        }
        return resDirectories;
    }

    public static class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project project) {
            this.myProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (facets.isEmpty()) {
                return;
            }
            Object object = DIR_MAP_LOCK;
            synchronized (object) {
                indicator.setText("Indexing resources");
                indicator.setIndeterminate(false);
                Map<VirtualFile, AndroidFacet> resDirectories = ResourceFolderRegistry.getResourceDirectoriesForFacets(facets);
                ResourceFolderRegistry.filterOutCached(resDirectories);
                if (resDirectories.isEmpty()) {
                    return;
                }
                File projectCacheRoot = ResourceFolderRepositoryFileCacheService.get().getProjectDir(this.myProject);
                if (projectCacheRoot == null) {
                    return;
                }
                try {
                    FileUtil.ensureExists((File)projectCacheRoot);
                }
                catch (IOException e) {
                    return;
                }
                Application application = ApplicationManager.getApplication();
                assert (!application.isWriteAccessAllowed());
                List<ResourceFolderRepository> repositories = PopulateCachesTask.executeParallel(indicator, resDirectories);
                for (ResourceFolderRepository repository : repositories) {
                    ResourceFolderRegistry.putRepositoryInCache(this.myProject, repository.getResourceDir(), repository);
                }
            }
        }

        private static List<ResourceFolderRepository> executeParallel(@NotNull ProgressIndicator indicator, @NotNull Map<VirtualFile, AndroidFacet> resDirectories) {
            int numDone = 0;
            ArrayList repositories = Lists.newArrayList();
            int maxThreads = Math.min(4, Runtime.getRuntime().availableProcessors());
            BoundedTaskExecutor parallelExecutor = new BoundedTaskExecutor((Executor)PooledThreadExecutor.INSTANCE, maxThreads);
            ArrayList repositoryJobs = Lists.newArrayList();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                repositoryJobs.add(PopulateCachesTask.queueRepositoryFuture(parallelExecutor, entry.getValue(), entry.getKey()));
            }
            for (Future job : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    repositories.add(job.get());
                }
                catch (ExecutionException executionException) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
            return repositories;
        }

        private static Future<ResourceFolderRepository> queueRepositoryFuture(@NotNull BoundedTaskExecutor myParallelBuildExecutor, @NotNull AndroidFacet facet, @NotNull VirtualFile dir) {
            return myParallelBuildExecutor.submit(() -> ResourceFolderRepository.create(facet, dir, null));
        }
    }
}

