/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.DataBindingInfo;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class PsiResourceFile
extends ResourceFile
implements Iterable<ResourceItem> {
    private static final File DUMMY_FILE = new File("");
    private PsiFile myFile;
    private String myName;
    private ResourceFolderType myFolderType;
    private Multimap<String, ResourceItem> myDuplicates;
    private DataBindingInfo myDataBindingInfo;

    public PsiResourceFile(PsiFile file, ResourceItem item, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration) {
        super(DUMMY_FILE, item, qualifiers, folderConfiguration);
        this.myFile = file;
        this.myName = file.getName();
        this.myFolderType = folderType;
    }

    public PsiResourceFile(PsiFile file, List<ResourceItem> items, String qualifiers, ResourceFolderType folderType, FolderConfiguration folderConfiguration) {
        super(DUMMY_FILE, items, qualifiers, folderConfiguration);
        this.myFile = file;
        this.myName = file.getName();
        this.myFolderType = folderType;
    }

    public PsiFile getPsiFile() {
        return this.myFile;
    }

    public File getFile() {
        if (this.mFile == null || this.mFile == DUMMY_FILE) {
            VirtualFile virtualFile = this.myFile.getVirtualFile();
            this.mFile = virtualFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile) : super.getFile();
        }
        return this.mFile;
    }

    public String getName() {
        return this.myName;
    }

    ResourceFolderType getFolderType() {
        return this.myFolderType;
    }

    public void setPsiFile(PsiFile psiFile, String qualifiers) {
        this.mFile = null;
        this.myFile = psiFile;
        this.setQualifiers(qualifiers);
        this.myFolderType = ResourceHelper.getFolderType(psiFile);
    }

    public void addItems(Iterable<ResourceItem> items) {
        for (ResourceItem item : items) {
            this.addItem(item);
        }
    }

    public void removeItems(Iterable<ResourceItem> items) {
        for (ResourceItem item : items) {
            this.removeItem(item);
        }
    }

    public void addItem(ResourceItem item) {
        item.setSource((DataFile)this);
        String key = item.getKey();
        ResourceItem prev = (ResourceItem)this.mItems.get(key);
        if (prev != null) {
            if (this.myDuplicates == null) {
                this.myDuplicates = ArrayListMultimap.create();
            }
            this.myDuplicates.put((Object)key, (Object)prev);
        }
        this.mItems.put(key, item);
    }

    public void removeItem(ResourceItem item) {
        Collection prev;
        String key = item.getKey();
        if (this.myDuplicates != null && (prev = this.myDuplicates.get((Object)key)) != null && prev.contains(item)) {
            this.myDuplicates.remove((Object)key, (Object)item);
            if (this.myDuplicates.isEmpty()) {
                this.myDuplicates = null;
            }
            item.setSource(null);
            return;
        }
        this.mItems.remove(key);
        item.setSource(null);
        if (this.myDuplicates != null && (prev = this.myDuplicates.get((Object)key)) != null && !prev.isEmpty()) {
            ResourceItem first = (ResourceItem)prev.iterator().next();
            this.myDuplicates.remove((Object)key, (Object)first);
            this.mItems.put(key, first);
            if (this.myDuplicates.isEmpty()) {
                this.myDuplicates = null;
            }
        }
    }

    public void replace(ResourceItem oldItem, ResourceItem newItem) {
        this.removeItem(oldItem);
        this.addItem(newItem);
    }

    @Override
    public Iterator<ResourceItem> iterator() {
        if (this.myDuplicates == null) {
            return this.mItems.values().iterator();
        }
        return Iterators.concat(this.mItems.values().iterator(), this.myDuplicates.values().iterator());
    }

    public void setDataBindingInfo(DataBindingInfo dataBindingInfo) {
        this.myDataBindingInfo = dataBindingInfo;
    }

    @Nullable
    public DataBindingInfo getDataBindingInfo() {
        return this.myDataBindingInfo;
    }
}

