/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.res2.DataBindingResourceItem;
import com.android.ide.common.res2.DataBindingResourceType;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PsiDataBindingResourceItem
extends DataBindingResourceItem {
    private XmlTag myXmlTag;
    private Map<String, String> myData;

    public PsiDataBindingResourceItem(String name, DataBindingResourceType type, XmlTag xmlTag) {
        super(name, type);
        this.myXmlTag = xmlTag;
        this.myData = Maps.newHashMap();
        for (String data : type.attributes) {
            this.myData.put(data, StringUtil.unescapeXml((String)this.myXmlTag.getAttributeValue(data)));
        }
    }

    public String getExtra(String name) {
        return this.myData.get(name);
    }

    @Nullable
    public String getTypeDeclaration() {
        String type = this.getExtra("type");
        return type == null ? null : type.replace('$', '.');
    }

    public XmlTag getXmlTag() {
        return this.myXmlTag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PsiDataBindingResourceItem item = (PsiDataBindingResourceItem)((Object)o);
        if (!this.myData.equals(item.myData)) {
            return false;
        }
        return this.myXmlTag.equals(item.myXmlTag);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myXmlTag.hashCode();
        result = 31 * result + this.myData.hashCode();
        return result;
    }
}

