/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ModuleResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepositoryRootListener;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        super(facet.getModule().getName() + " with modules", delegates);
        this.myFacet = facet;
    }

    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet != null) {
            return facet.getProjectResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static ProjectResourceRepository getProjectResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        return facet.getProjectResources(createIfNecessary);
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet) {
        List<LocalResourceRepository> resources = ProjectResourceRepository.computeRepositories(facet);
        ProjectResourceRepository repository = new ProjectResourceRepository(facet, resources);
        ProjectResourceRepositoryRootListener.ensureSubscribed(facet.getModule().getProject());
        return repository;
    }

    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet) {
        LocalResourceRepository main = ModuleResourceRepository.getModuleResources(facet, true);
        List<AndroidFacet> dependentFacets = AndroidUtils.getAllAndroidDependencies(facet.getModule(), true);
        if (dependentFacets.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)dependentFacets.size());
        for (AndroidFacet f : dependentFacets) {
            LocalResourceRepository r = ModuleResourceRepository.getModuleResources(f, true);
            resources.add(r);
        }
        resources.add(main);
        return resources;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.updateRoots(repositories);
    }

    void updateRoots(List<LocalResourceRepository> resourceDirectories) {
        this.invalidateResourceDirs();
        if (!resourceDirectories.equals(this.myChildren)) {
            this.setChildren(resourceDirectories);
        }
    }

    @NotNull
    static ProjectResourceRepository createForTest(AndroidFacet facet, List<LocalResourceRepository> modules) {
        return new ProjectResourceRepository(facet, modules);
    }
}

