/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.webp;

import com.android.tools.idea.rendering.webp.NativeLibHelper;
import com.google.webp.libwebp;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpImageReaderSpi
extends ImageReaderSpi {
    public static final String EXT_WEBP = "webp";
    private static final byte[] RIFF = new byte[]{82, 73, 70, 70};
    private static final byte[] WEBP = new byte[]{87, 69, 66, 80};
    private static final int MAX_FILE_SIZE = 0x6400000;
    private static Logger ourLogger;

    public static void ensureWebpRegistered() {
    }

    @NotNull
    static Logger getLogger() {
        if (ourLogger == null) {
            ourLogger = Logger.getInstance(WebpImageReaderSpi.class);
        }
        return ourLogger;
    }

    private WebpImageReaderSpi() {
        this.vendorName = "Google Inc.";
        this.version = "1";
        this.suffixes = new String[]{EXT_WEBP};
        this.names = this.suffixes;
        this.MIMETypes = new String[]{"image/webp"};
        this.pluginClassName = WebpReader.class.getName();
        this.inputTypes = new Class[]{ImageInputStream.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(@NotNull Object source) throws IOException {
        assert (source instanceof ImageInputStream);
        ImageInputStream stream = (ImageInputStream)source;
        long length = stream.length();
        if (length > 0x6400000L) {
            return false;
        }
        stream.mark();
        try {
            byte[] header = new byte[12];
            int bytesRead = stream.read(header, 0, 12);
            boolean bl = bytesRead == 12 && WebpImageReaderSpi.arrayEquals(header, 0, RIFF.length, RIFF) && WebpImageReaderSpi.arrayEquals(header, 8, WEBP.length, WEBP) && NativeLibHelper.loadNativeLibraryIfNeeded();
            return bl;
        }
        finally {
            try {
                stream.reset();
            }
            catch (IOException e) {
                WebpImageReaderSpi.getLogger().error((Throwable)e);
            }
        }
    }

    private static boolean arrayEquals(@NotNull byte[] a1, int offset, int len, @NotNull byte[] a2) {
        for (int i = 0; i < len; ++i) {
            if (a1[offset + i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ImageReader createReaderInstance(Object extension) throws IOException {
        if (!NativeLibHelper.loadNativeLibraryIfNeeded()) {
            throw new IOException("webp decoder library not loaded.");
        }
        return new WebpReader(this);
    }

    @Override
    @NotNull
    public String getDescription(Locale locale) {
        return "Webp Image decoding service.";
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(new WebpImageReaderSpi(), ImageReaderSpi.class);
    }

    private static class WebpReader
    extends ImageReader {
        private static final String UNABLE_TO_READ_WEBP_IMAGE = "Unable to read webp image";
        @Nullable
        private byte[] myInputBytes;
        private final int[] myWidthOut = new int[1];
        private final int[] myHeightOut = new int[1];
        private int myError;

        public WebpReader(ImageReaderSpi originatingProvider) {
            super(originatingProvider);
        }

        @Override
        public void dispose() {
            this.myInputBytes = null;
        }

        @Override
        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.myInputBytes = null;
            this.myError = 0;
        }

        @Override
        public int getNumImages(boolean allowSearch) throws IOException {
            return this.myInputBytes == null ? 0 : 1;
        }

        private void loadInfoIfNeeded() throws IOException {
            if (this.input != null && this.myInputBytes == null) {
                this.myInputBytes = WebpReader.readStreamFully((ImageInputStream)this.input);
                this.myError = libwebp.WebPGetInfo((byte[])this.myInputBytes, (long)this.myInputBytes.length, (int[])this.myWidthOut, (int[])this.myHeightOut);
            }
        }

        @NotNull
        private static byte[] readStreamFully(@NotNull ImageInputStream stream) throws IOException {
            int idx;
            if (stream.length() != -1L) {
                byte[] bytes = new byte[(int)stream.length()];
                stream.readFully(bytes);
                return bytes;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(0x100000);
            int bufferSize = 16384;
            byte[] bytes = new byte[16384];
            for (idx = 0; idx < 6400; ++idx) {
                int read = stream.read(bytes, 0, 16384);
                buffer.write(bytes, 0, read);
                if (read != 16384) break;
            }
            if (idx == 6400) {
                throw new IOException("webp image too large");
            }
            return buffer.toByteArray();
        }

        @Override
        public int getWidth(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myWidthOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        public int getHeight(int imageIndex) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError != 0) {
                return this.myHeightOut[0];
            }
            throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
        }

        @Override
        @Nullable
        public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        @Override
        @Nullable
        public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
            return null;
        }

        @Override
        @NotNull
        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            this.loadInfoIfNeeded();
            if (this.myError == 0) {
                throw new IOException(UNABLE_TO_READ_WEBP_IMAGE);
            }
            assert (this.myInputBytes != null);
            byte[] argb = libwebp.WebPDecodeARGB((byte[])this.myInputBytes, (long)this.myInputBytes.length, (int[])this.myWidthOut, (int[])this.myHeightOut);
            BufferedImage bi = new BufferedImage(this.myWidthOut[0], this.myHeightOut[0], 2);
            int[] a = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
            IntBuffer intBuf = ByteBuffer.wrap(argb).asIntBuffer();
            assert (a.length == intBuf.remaining());
            intBuf.get(a);
            return bi;
        }
    }
}

