/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagSnapshot {
    @Nullable
    public final String namespace;
    @NotNull
    public final String tagName;
    @Nullable
    public final XmlTag tag;
    @Nullable
    public final String prefix;
    @Nullable
    private TagSnapshot myNext;
    @NotNull
    public List<TagSnapshot> children;
    @NotNull
    public List<AttributeSnapshot> attributes;

    private TagSnapshot(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
    }

    public static TagSnapshot createSyntheticTag(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        return new TagSnapshot(tag, tagName, prefix, namespace, attributes, children);
    }

    @NotNull
    public static TagSnapshot createTagSnapshot(@NotNull XmlTag tag) {
        ArrayList children;
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithCapacity((int)subTags.length);
            for (XmlTag subTag : subTags) {
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag);
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        return new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
    }

    @NotNull
    public static TagSnapshot createTagSnapshotWithoutChildren(@NotNull XmlTag tag) {
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        List<TagSnapshot> children = Collections.emptyList();
        return new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
    }

    @Nullable
    public String getAttribute(@NotNull String name) {
        return this.getAttribute(name, null);
    }

    @Nullable
    public String getAttribute(@NotNull String name, @Nullable String namespace) {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value) {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            this.attributes.remove(i);
            break;
        }
        if (value != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = Lists.newArrayList();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value));
        }
    }

    @Nullable
    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }

    public long getSignature() {
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Hasher hasher = hashFunction.newHasher();
        hasher.putString((CharSequence)this.tagName, Charsets.UTF_8);
        for (AttributeSnapshot attribute : this.attributes) {
            if (attribute.prefix != null) {
                hasher.putString((CharSequence)attribute.prefix, Charsets.UTF_8);
            }
            hasher.putString((CharSequence)attribute.name, Charsets.UTF_8);
            if (attribute.value == null) continue;
            hasher.putString((CharSequence)attribute.value, Charsets.UTF_8);
        }
        return hasher.hash().asLong();
    }
}

