/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.profiling.capture;

import com.android.tools.idea.profiling.capture.CaptureType;
import com.android.tools.idea.profiling.capture.CaptureTypeService;
import com.android.tools.idea.stats.UsageTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CaptureEditorProvider
implements FileEditorProvider,
DumbAware {
    @NonNls
    private static final String ID = "capture-editor";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        CaptureType type = CaptureTypeService.getInstance().getTypeFor(file);
        return type != null && type.accept(file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        CaptureType type = CaptureTypeService.getInstance().getTypeFor(file);
        if (type == null) {
            throw new IllegalStateException("Type has been removed between accept and createEditor");
        }
        UsageTracker.getInstance().trackEvent("profiling", "captureOpened", type.getName(), null);
        return type.createEditor(project, file);
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    public String getEditorTypeId() {
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

