/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AndroidProjectPaths {
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcDirectory;
    @Nullable
    private File myTestDirectory;
    @Nullable
    private File myResDirectory;
    @Nullable
    private File myAidlDirectory;
    @Nullable
    private File myManifestDirectory;

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet) {
        this(androidFacet, AndroidProjectPaths.getSourceProviders(androidFacet, null).get(0));
    }

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet, @NotNull SourceProvider sourceProvider) {
        Collection aidlDirectories;
        this.myAndroidFacet = androidFacet;
        Module module = this.getModule();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            this.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        this.mySrcDirectory = (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
        List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
        this.myTestDirectory = testsRoot.size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
        Collection resDirectories = sourceProvider.getResDirectories();
        if (!resDirectories.isEmpty()) {
            this.myResDirectory = (File)resDirectories.iterator().next();
        }
        if (!(aidlDirectories = sourceProvider.getAidlDirectories()).isEmpty()) {
            this.myAidlDirectory = (File)aidlDirectories.iterator().next();
        }
        this.myManifestDirectory = sourceProvider.getManifestFile().getParentFile();
    }

    @NotNull
    public static List<SourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (targetDirectory != null) {
            return IdeaSourceProvider.getSourceProvidersForFile(androidFacet, targetDirectory, androidFacet.getMainSourceProvider());
        }
        return IdeaSourceProvider.getAllSourceProviders(androidFacet);
    }

    @NotNull
    public AndroidFacet getAndroidFacet() {
        return this.myAndroidFacet;
    }

    @NotNull
    public Module getModule() {
        return this.myAndroidFacet.getModule();
    }

    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    public File getSrcDirectory() {
        return this.mySrcDirectory;
    }

    @Nullable
    public File getTestDirectory() {
        return this.myTestDirectory;
    }

    @Nullable
    public File getResDirectory() {
        return this.myResDirectory;
    }

    @Nullable
    public File getAidlDirectory() {
        return this.myAidlDirectory;
    }

    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }
}

