/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class AndroidPackageUtils {
    private AndroidPackageUtils() {
    }

    @NotNull
    public static String getPackageForApplication(@NotNull AndroidFacet androidFacet) {
        AndroidModel androidModel = androidFacet.getAndroidModel();
        assert (androidModel != null);
        return androidModel.getApplicationId();
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidProjectPaths paths, @NotNull VirtualFile targetDirectory) {
        ProjectRootManager projectManager;
        String suggestedPackage;
        Module module = paths.getModule();
        File srcDirectory = paths.getSrcDirectory();
        if (srcDirectory != null && (suggestedPackage = (projectManager = ProjectRootManager.getInstance((Project)module.getProject())).getFileIndex().getPackageNameByDirectory(targetDirectory)) != null && !suggestedPackage.isEmpty()) {
            return suggestedPackage;
        }
        return AndroidPackageUtils.getPackageForApplication(paths.getAndroidFacet());
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull SourceProvider sourceProvider, @NotNull VirtualFile targetDirectory) {
        return AndroidPackageUtils.getPackageForPath(new AndroidProjectPaths(androidFacet, sourceProvider), targetDirectory);
    }

    @NotNull
    public static String getPackageForPath(@NotNull AndroidFacet androidFacet, @NotNull List<SourceProvider> sourceProviders, @NotNull VirtualFile targetDirectory) {
        if (sourceProviders.size() > 0) {
            return AndroidPackageUtils.getPackageForPath(androidFacet, sourceProviders.get(0), targetDirectory);
        }
        return AndroidPackageUtils.getPackageForApplication(androidFacet);
    }
}

