/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.cpp;

import com.android.tools.idea.npw.cpp.CppStandardType;
import com.android.tools.idea.npw.cpp.RuntimeLibraryType;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStepWithDescription;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Joiner;
import com.intellij.openapi.Disposable;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureCppSupportStep
extends DynamicWizardStepWithDescription {
    private static final ScopedStateStore.Key<CppStandardType> KEY_STANDARD_TYPE = ScopedStateStore.createKey("cppStandard", ScopedStateStore.Scope.STEP, CppStandardType.class);
    private static final ScopedStateStore.Key<Boolean> KEY_ENABLE_EXCEPTIONS = ScopedStateStore.createKey("cppEnableExceptions", ScopedStateStore.Scope.STEP, Boolean.class);
    private static final ScopedStateStore.Key<Boolean> KEY_ENABLE_RTTI = ScopedStateStore.createKey("cppEnableRtti", ScopedStateStore.Scope.STEP, Boolean.class);
    private static final ScopedStateStore.Key<RuntimeLibraryType> KEY_RUNTIME_LIBRARY_TYPE = ScopedStateStore.createKey("cppRuntimeLibrary", ScopedStateStore.Scope.STEP, RuntimeLibraryType.class);
    private static final ScopedStateStore.Key<String> KEY_RUNTIME_LIBRARY_TYPE_STRING = ScopedStateStore.createKey("cppRuntimeLibraryString", ScopedStateStore.Scope.STEP, String.class);
    private JPanel myPanel;
    private JComboBox<CppStandardType> myCppStandardCombo;
    private JCheckBox myExceptionSupportCheck;
    private JBLabel myIconLabel;
    private JComboBox<RuntimeLibraryType> myRuntimeLibraryCombo;
    private JCheckBox myRttiSupportCheck;
    private JBLabel myRuntimeLibraryLabel;

    public ConfigureCppSupportStep(@NotNull Disposable disposable) {
        super(disposable);
        this.$$$setupUI$$$();
        this.myPanel.setBorder(ConfigureCppSupportStep.createBodyBorder());
        this.setBodyComponent(this.myPanel);
        this.myIconLabel.setIcon(AndroidIcons.Wizards.CppConfiguration);
    }

    @Override
    public void init() {
        super.init();
        this.myRuntimeLibraryCombo.setModel((ComboBoxModel<RuntimeLibraryType>)new CollectionComboBoxModel(Arrays.asList(RuntimeLibraryType.values())));
        this.myCppStandardCombo.setModel((ComboBoxModel<CppStandardType>)new CollectionComboBoxModel(Arrays.asList(CppStandardType.values())));
        this.register(KEY_RUNTIME_LIBRARY_TYPE, this.myRuntimeLibraryCombo);
        this.register(KEY_STANDARD_TYPE, this.myCppStandardCombo);
        this.register(KEY_ENABLE_EXCEPTIONS, this.myExceptionSupportCheck);
        this.register(KEY_ENABLE_RTTI, this.myRttiSupportCheck);
        this.myState.put(KEY_RUNTIME_LIBRARY_TYPE, RuntimeLibraryType.GABIXX);
        this.myState.put(KEY_STANDARD_TYPE, CppStandardType.DEFAULT);
        this.registerValueDeriver(KEY_RUNTIME_LIBRARY_TYPE_STRING, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 1.makeSetOf(KEY_RUNTIME_LIBRARY_TYPE);
            }

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                RuntimeLibraryType type = (RuntimeLibraryType)((Object)state.get(KEY_RUNTIME_LIBRARY_TYPE));
                return type == null ? null : type.getGradleName();
            }
        });
        this.registerValueDeriver(WizardConstants.CPP_FLAGS_KEY, new ScopedDataBinder.ValueDeriver<String>(){

            @Override
            @Nullable
            public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
                return 2.makeSetOf(KEY_STANDARD_TYPE, KEY_ENABLE_EXCEPTIONS, KEY_ENABLE_RTTI);
            }

            @Override
            @Nullable
            public String deriveValue(@NotNull ScopedStateStore state, @Nullable ScopedStateStore.Key changedKey, @Nullable String currentValue) {
                ArrayList<String> flags = new ArrayList<String>();
                flags.add(state.getNotNull(KEY_STANDARD_TYPE, CppStandardType.DEFAULT).getCompilerFlag());
                flags.add(state.getNotNull(KEY_ENABLE_RTTI, false) != false ? "-frtti" : null);
                flags.add(state.getNotNull(KEY_ENABLE_EXCEPTIONS, false) != false ? "-fexceptions" : null);
                return Joiner.on((char)' ').skipNulls().join(flags);
            }
        });
        this.myRuntimeLibraryCombo.setVisible(false);
        this.myRuntimeLibraryLabel.setVisible(false);
    }

    @Override
    @NotNull
    public String getStepName() {
        return "Customize C++ Support";
    }

    @Override
    @NotNull
    protected String getStepTitle() {
        return "Customize C++ Support";
    }

    @Override
    @Nullable
    protected String getStepDescription() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCppStandardCombo;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JBLabel jBLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("C++ Standard");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.myRuntimeLibraryLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Runtime Support Library");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myCppStandardCombo = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myRuntimeLibraryCombo = jComboBox2;
        jPanel.add(jComboBox2, new GridConstraints(3, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myExceptionSupportCheck = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Exceptions Support (-fexceptions)");
        jPanel.add((Component)jCheckBox2, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRttiSupportCheck = jCheckBox = new JCheckBox();
        jCheckBox.setText("Runtime Type Information Support (-frtti)");
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myIconLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 4, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(4, 1, 1, 2, 0, 2, 1, 2, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(1, 1, 1, 2, 0, 2, 1, 2, null, null, null));
    }

    @Override
    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

