/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.ui;

import com.android.tools.idea.npw.assetstudio.assets.TextAsset;
import com.android.tools.idea.npw.assetstudio.ui.AssetComponent;
import com.android.tools.idea.ui.ProportionalLayout;
import com.android.tools.idea.ui.properties.BindingsManager;
import com.android.tools.idea.ui.properties.InvalidationListener;
import com.android.tools.idea.ui.properties.ObservableValue;
import com.android.tools.idea.ui.properties.expressions.value.AsValueExpression;
import com.android.tools.idea.ui.properties.swing.SelectedItemProperty;
import com.android.tools.idea.ui.properties.swing.TextProperty;
import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public final class TextAssetEditor
extends JPanel
implements AssetComponent<TextAsset> {
    private final TextAsset myTextAsset = new TextAsset();
    private final BindingsManager myBindings = new BindingsManager();
    private final List<ActionListener> myListeners = Lists.newArrayListWithExpectedSize((int)1);
    private final JTextField myTextField = new JTextField();
    private final JComboBox myFontCombo = new JComboBox();

    public TextAssetEditor() {
        super(ProportionalLayout.fromString("50px,180px"));
        this.add((Component)this.myTextField, new ProportionalLayout.Constraint(0, 0));
        this.add((Component)this.myFontCombo, new ProportionalLayout.Constraint(0, 1));
        this.myBindings.bindTwoWay(new TextProperty(this.myTextField), this.myTextAsset.text());
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        for (String fontFamily : fontFamilies) {
            this.myFontCombo.addItem(fontFamily);
        }
        String initialFont = (String)this.myTextAsset.fontFamily().get();
        this.myFontCombo.setSelectedItem(initialFont);
        SelectedItemProperty selectedFont = new SelectedItemProperty(this.myFontCombo);
        this.myBindings.bind(this.myTextAsset.fontFamily(), new AsValueExpression(selectedFont));
        InvalidationListener onTextChanged = new InvalidationListener(){

            @Override
            public void onInvalidated(@NotNull ObservableValue<?> sender) {
                ActionEvent e = new ActionEvent(TextAssetEditor.this, 1001, null);
                for (ActionListener listener : TextAssetEditor.this.myListeners) {
                    listener.actionPerformed(e);
                }
            }
        };
        this.myTextAsset.text().addListener(onTextChanged);
        this.myTextAsset.fontFamily().addListener(onTextChanged);
    }

    @Override
    @NotNull
    public TextAsset getAsset() {
        return this.myTextAsset;
    }

    @Override
    public void addAssetListener(@NotNull ActionListener l) {
        this.myListeners.add(l);
    }

    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.clear();
    }
}

