/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.icon;

import com.android.assetstudiolib.NotificationIconGenerator;
import com.android.resources.Density;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.io.FileUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CategoryIconMap {
    private static final Filter ACCEPT_ALL = new Filter(){

        @Override
        public boolean accept(@NotNull String category) {
            return true;
        }
    };
    private static final Map<Density, Pattern> DENSITY_PATTERNS;
    @NotNull
    private final Map<String, Map<String, BufferedImage>> myCategoryMap;

    public CategoryIconMap(@NotNull Map<String, Map<String, BufferedImage>> categoryMap) {
        this.myCategoryMap = categoryMap;
    }

    @Nullable
    public static Density pathToDensity(@NotNull String iconPath) {
        iconPath = FileUtil.toSystemIndependentName((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap() {
        return this.toDensityMap(ACCEPT_ALL);
    }

    @NotNull
    public Map<Density, BufferedImage> toDensityMap(@NotNull Filter filter) {
        HashMap densityImageMap = Maps.newHashMap();
        for (String category : this.myCategoryMap.keySet()) {
            if (!filter.accept(category)) continue;
            Map<String, BufferedImage> pathImageMap = this.myCategoryMap.get(category);
            for (String path : pathImageMap.keySet()) {
                Density density = CategoryIconMap.pathToDensity(path);
                if (density == null) continue;
                BufferedImage image = pathImageMap.get(path);
                densityImageMap.put(density, image);
            }
        }
        return densityImageMap;
    }

    @NotNull
    public Map<File, BufferedImage> toFileMap(@NotNull File rootDir) {
        HashMap outputMap = Maps.newHashMap();
        for (Map<String, BufferedImage> pathImageMap : this.myCategoryMap.values()) {
            for (Map.Entry<String, BufferedImage> pathImageEntry : pathImageMap.entrySet()) {
                outputMap.put(new File(rootDir, pathImageEntry.getKey()), pathImageEntry.getValue());
            }
        }
        return outputMap;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
    }

    public static final class NotificationFilter
    implements Filter {
        @NotNull
        private final NotificationIconGenerator.Version myVersion;

        public NotificationFilter(@NotNull NotificationIconGenerator.Version version) {
            this.myVersion = version;
        }

        @Override
        public boolean accept(@NotNull String category) {
            return this.myVersion.getDisplayName().equals(category);
        }
    }

    public static interface Filter {
        public boolean accept(@NotNull String var1);
    }
}

