/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.ide.common.vectordrawable.Svg2Vector;
import com.android.ide.common.vectordrawable.VdOverrideInfo;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.npw.assetstudio.assets.LayeredImageConverter;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public final class VectorAsset
extends BaseAsset {
    private static final String ERROR_EMPTY_PREVIEW = "Could not generate a preview";
    private final ObjectProperty<FileType> myFileType = new ObjectValueProperty<FileType>(FileType.SVG);
    private final ObjectProperty<File> myPath = new ObjectValueProperty<File>(new File(System.getProperty("user.home")));
    private final IntProperty myOpacity = new IntValueProperty(100);
    private final BoolProperty myAutoMirrored = new BoolValueProperty();
    private final IntProperty myOutputWidth = new IntValueProperty();
    private final IntProperty myOutputHeight = new IntValueProperty();

    public VectorAsset(@NotNull FileType fileType) {
        this.type().set(fileType);
    }

    @NotNull
    public static FileType typeFromExtension(@NotNull String path) {
        String fullPath = new File(path).getAbsolutePath();
        int index = fullPath.lastIndexOf(46);
        String extension = path.substring(index + 1);
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "svg": {
                return FileType.SVG;
            }
            case "psd": {
                return FileType.LAYERED_IMAGE;
            }
        }
        return FileType.VECTOR_DRAWABLE;
    }

    @NotNull
    public ObjectProperty<FileType> type() {
        return this.myFileType;
    }

    @NotNull
    public ObjectProperty<File> path() {
        return this.myPath;
    }

    @NotNull
    public IntProperty opacity() {
        return this.myOpacity;
    }

    @NotNull
    public BoolProperty autoMirrored() {
        return this.myAutoMirrored;
    }

    @NotNull
    public IntProperty outputWidth() {
        return this.myOutputWidth;
    }

    @NotNull
    public IntProperty outputHeight() {
        return this.myOutputHeight;
    }

    @NotNull
    public ParseResult parse(int previewWidth) {
        return this.tryParse(previewWidth);
    }

    @NotNull
    public ParseResult parse() {
        return this.parse(0);
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        return this.parse().getImage();
    }

    @NotNull
    private ParseResult tryParse(int previewWidth) {
        Document vdDocument;
        StringBuilder errorBuffer = new StringBuilder();
        File path = (File)this.myPath.get();
        if (!path.exists() || path.isDirectory()) {
            return ParseResult.INVALID;
        }
        String xmlFileContent = null;
        FileType fileType = (FileType)((Object)this.myFileType.get());
        if (fileType.equals((Object)FileType.SVG)) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            String errorLog = Svg2Vector.parseSvgToXml((File)path, (OutputStream)outStream);
            errorBuffer.append(errorLog);
            xmlFileContent = ((Object)outStream).toString();
        } else if (fileType.equals((Object)FileType.LAYERED_IMAGE)) {
            try {
                xmlFileContent = new LayeredImageConverter().toVectorDrawableXml(path);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        } else {
            try {
                xmlFileContent = Files.toString((File)path, (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                errorBuffer.append(e.getMessage());
            }
        }
        BufferedImage image = null;
        int originalWidth = 0;
        int originalHeight = 0;
        if (xmlFileContent != null && (vdDocument = VdPreview.parseVdStringIntoDocument((String)xmlFileContent, (StringBuilder)errorBuffer)) != null) {
            VdPreview.SourceSize vdOriginalSize = VdPreview.getVdOriginalSize((Document)vdDocument);
            originalWidth = vdOriginalSize.getWidth();
            originalHeight = vdOriginalSize.getHeight();
            String overriddenXml = this.overrideXmlFileContent(vdDocument, vdOriginalSize, errorBuffer);
            if (overriddenXml != null) {
                xmlFileContent = overriddenXml;
            }
            if (previewWidth <= 0) {
                previewWidth = (Integer)this.myOutputWidth.get() > 0 ? (Integer)this.myOutputWidth.get() : originalWidth;
            }
            VdPreview.TargetSize imageTargetSize = VdPreview.TargetSize.createSizeFromWidth((int)previewWidth);
            image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)imageTargetSize, (String)xmlFileContent, (StringBuilder)errorBuffer);
        }
        if (image == null) {
            errorBuffer.insert(0, "Could not generate a preview\n");
            return new ParseResult(errorBuffer.toString());
        }
        return new ParseResult(errorBuffer.toString(), image, originalWidth, originalHeight, xmlFileContent);
    }

    @Nullable
    private String overrideXmlFileContent(@NotNull Document vdDocument, @NotNull VdPreview.SourceSize vdOriginalSize, @NotNull StringBuilder errorBuffer) {
        int finalWidth = vdOriginalSize.getWidth();
        int finalHeight = vdOriginalSize.getHeight();
        Integer outputWidth = (Integer)this.myOutputWidth.get();
        Integer outputHeight = (Integer)this.myOutputHeight.get();
        if (outputWidth > 0) {
            finalWidth = outputWidth;
        }
        if (outputHeight > 0) {
            finalHeight = outputHeight;
        }
        finalWidth = Math.max(1, finalWidth);
        finalHeight = Math.max(1, finalHeight);
        finalWidth = Math.min(4096, finalWidth);
        finalHeight = Math.min(4096, finalHeight);
        VdOverrideInfo overrideInfo = new VdOverrideInfo(finalWidth, finalHeight, ((Integer)this.myOpacity.get()).intValue(), ((Boolean)this.myAutoMirrored.get()).booleanValue());
        return VdPreview.overrideXmlContent((Document)vdDocument, (VdOverrideInfo)overrideInfo, (StringBuilder)errorBuffer);
    }

    public static final class ParseResult {
        private static final ParseResult INVALID = new ParseResult();
        @NotNull
        private final String myErrors;
        @NotNull
        private final BufferedImage myImage;
        private final int myOriginalWidth;
        private final int myOriginalHeight;
        private final boolean myIsValid;
        @NotNull
        private final String myXmlContent;

        private ParseResult() {
            this("", AssetStudioUtils.createDummyImage(), 0, 0, "");
        }

        public ParseResult(@NotNull String errors) {
            this(errors, INVALID.getImage(), 0, 0, "");
        }

        public ParseResult(@NotNull String errors, @NotNull BufferedImage image, int originalWidth, int originalHeight, @NotNull String xmlContent) {
            this.myErrors = errors;
            this.myImage = image;
            this.myOriginalWidth = originalWidth;
            this.myOriginalHeight = originalHeight;
            this.myXmlContent = xmlContent;
            this.myIsValid = originalWidth > 0 && originalHeight > 0;
        }

        public boolean isValid() {
            return this.myIsValid;
        }

        public int getOriginalWidth() {
            return this.myOriginalWidth;
        }

        public int getOriginalHeight() {
            return this.myOriginalHeight;
        }

        @NotNull
        public String getErrors() {
            return this.myErrors;
        }

        @NotNull
        public BufferedImage getImage() {
            return this.myImage;
        }

        @NotNull
        public String getXmlContent() {
            return this.myXmlContent;
        }
    }

    public static enum FileType {
        SVG,
        LAYERED_IMAGE,
        VECTOR_DRAWABLE;

    }
}

