/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.tools.idea.npw.assetstudio.AssetStudioUtils;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public abstract class BaseAsset {
    private final BoolProperty myTrimmed = new BoolValueProperty();
    private final IntProperty myPaddingPercent = new IntValueProperty();
    private final ObjectProperty<Color> myColor = new ObjectValueProperty<Color>(Color.BLACK);

    @NotNull
    public BoolProperty trimmed() {
        return this.myTrimmed;
    }

    @NotNull
    public IntProperty paddingPercent() {
        return this.myPaddingPercent;
    }

    @NotNull
    public ObjectProperty<Color> color() {
        return this.myColor;
    }

    @NotNull
    public final BufferedImage toImage() {
        BufferedImage image = this.createAsImage((Color)this.myColor.get());
        if (((Boolean)this.myTrimmed.get()).booleanValue()) {
            image = AssetStudioUtils.trim(image);
        }
        image = AssetStudioUtils.pad(image, (Integer)this.myPaddingPercent.get());
        return image;
    }

    @NotNull
    protected abstract BufferedImage createAsImage(@NotNull Color var1);
}

