/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.npw.AsyncValidator;
import com.android.tools.idea.npw.ImportUIUtil;
import com.android.tools.idea.npw.ModuleImportSettings;
import com.android.tools.idea.npw.ModulesTable;
import com.android.tools.idea.npw.NewModuleWizardState;
import com.android.tools.idea.wizard.dynamic.AndroidStudioWizardStep;
import com.android.tools.idea.wizard.template.TemplateWizardStep;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSourceLocationStep
extends ModuleWizardStep
implements AndroidStudioWizardStep {
    private static final int VALIDATION_STATUS_DISPLAY_DELAY = 50;
    private final Logger LOG;
    private final NewModuleWizardState myState;
    private final Timer myDelayedValidationProgressDisplay;
    @NotNull
    private final TemplateWizardStep.UpdateListener myUpdateListener;
    @NotNull
    private final WizardContext myContext;
    private JPanel myPanel;
    private TextFieldWithBrowseButton mySourceLocation;
    private JBLabel myErrorWarning;
    private AsyncProcessIcon myValidationProgress;
    private JBScrollPane myModulesScroller;
    private ModulesTable myModulesPanel;
    private JLabel myRequiredModulesLabel;
    private JLabel myModuleNameLabel;
    private JTextField myModuleNameField;
    private JLabel myPrimaryModuleState;
    private AsyncValidator<?> validator;
    private PathValidationResult myPageValidationResult;
    private boolean myValidating;
    private PageStatus myStatus;
    private Icon mySidePanelIcon;

    public ImportSourceLocationStep(@NotNull WizardContext context, @NotNull NewModuleWizardState state, @Nullable Icon sidePanelIcon, @Nullable TemplateWizardStep.UpdateListener listener) {
        this.$$$setupUI$$$();
        this.LOG = Logger.getInstance(ImportSourceLocationStep.class);
        this.myValidating = false;
        this.myErrorWarning.setBorder(BorderFactory.createEmptyBorder(16, 0, 0, 0));
        this.myContext = context;
        this.mySidePanelIcon = sidePanelIcon;
        this.myUpdateListener = listener == null ? new TemplateWizardStep.UpdateListener(){

            @Override
            public void update() {
            }
        } : listener;
        this.myState = state;
        this.myPanel.setBorder(new EmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
        this.myModulesScroller.setVisible(false);
        this.myModulesPanel.bindPrimaryModuleEntryComponents(new PrimaryModuleImportSettings(), this.myRequiredModulesLabel);
        PropertyChangeListener modulesListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedModules".equals(evt.getPropertyName())) {
                    ImportSourceLocationStep.this.updateStepStatus(ImportSourceLocationStep.this.myPageValidationResult);
                }
            }
        };
        this.myModulesPanel.addPropertyChangeListener("selectedModules", modulesListener);
        this.validator = new AsyncValidator<PathValidationResult>(ApplicationManager.getApplication()){

            @Override
            protected void showValidationResult(PathValidationResult result) {
                ImportSourceLocationStep.this.applyBackgroundOperationResult(result);
            }

            @Override
            @NotNull
            protected PathValidationResult validate() {
                return ImportSourceLocationStep.this.checkPath(ImportSourceLocationStep.this.mySourceLocation.getText());
            }
        };
        this.setupSourceLocationControls();
        this.myDelayedValidationProgressDisplay = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImportSourceLocationStep.this.myValidating) {
                    ImportSourceLocationStep.this.updateStatusDisplay(PageStatus.VALIDATING, null);
                }
            }
        });
    }

    private static String multiLineJLabelText(String ... messages) {
        StringBuilder builder = new StringBuilder("<html><body><p>");
        Joiner.on((String)"<br>").appendTo(builder, (Object[])messages);
        builder.append("</p></body></html>");
        return builder.toString();
    }

    public Icon getIcon() {
        return this.mySidePanelIcon;
    }

    private void setupSourceLocationControls() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        descriptor.setTitle("Select Source Location");
        descriptor.setDescription("Select existing ADT or Gradle project to import as a new subproject");
        this.mySourceLocation.addBrowseFolderListener(new TextBrowseFolderListener(descriptor));
        this.mySourceLocation.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ImportSourceLocationStep.this.invalidate();
            }
        });
        this.applyBackgroundOperationResult(this.checkPath(this.mySourceLocation.getText()));
        this.myErrorWarning.setIcon(null);
        this.myErrorWarning.setText(null);
    }

    private void updateStatusDisplay(@NotNull PageStatus status, @Nullable Object details) {
        this.myValidationProgress.setVisible(status.isSpinnerVisible());
        this.myErrorWarning.setText(status.getMessage(details));
        this.myErrorWarning.setIcon(status.getIcon());
        this.myUpdateListener.update();
    }

    private void invalidate() {
        if (!this.myDelayedValidationProgressDisplay.isRunning()) {
            this.myDelayedValidationProgressDisplay.start();
        }
        this.myValidating = true;
        this.validator.invalidate();
    }

    private void applyBackgroundOperationResult(@NotNull PathValidationResult result) {
        assert (EventQueue.isDispatchThread());
        Set<ModuleToImport> modules = null;
        Project project = this.myContext.getProject();
        try {
            if (result.myStatus == PageStatus.OK) {
                assert (result.myVfile != null && result.myImporter != null);
                modules = result.myImporter.findModules(result.myVfile);
                TreeSet missingSourceModuleNames = Sets.newTreeSet();
                for (ModuleToImport module : modules) {
                    if (module.location != null && module.location.exists()) continue;
                    missingSourceModuleNames.add(module.name);
                }
                if (!missingSourceModuleNames.isEmpty()) {
                    result = new PathValidationResult(PageStatus.MISSING_SUBPROJECTS, result.myVfile, result.myImporter, missingSourceModuleNames);
                }
            }
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
            result = PageStatus.INTERNAL_ERROR.result();
        }
        this.myValidating = false;
        this.myModulesPanel.setModules(project, result.myVfile, modules);
        this.myModulesScroller.setVisible(this.myModulesPanel.getComponentCount() > 0);
        ModuleImporter.setImporter(this.myContext, result.myImporter);
        this.updateStepStatus(result);
    }

    private void updateStepStatus(PathValidationResult result) {
        Object validationDetails = result.myDetails;
        PageStatus status = result.myStatus;
        HashMap selectedModules = Collections.emptyMap();
        if (!MessageType.ERROR.equals(status.severity)) {
            Set<ModuleToImport> modules = this.myModulesPanel.getSelectedModules();
            if (modules.isEmpty()) {
                status = PageStatus.NO_MODULES_SELECTED;
                validationDetails = null;
            } else {
                selectedModules = Maps.newHashMap();
                for (ModuleToImport module : modules) {
                    selectedModules.put(this.myModulesPanel.getModuleName(module), module.location);
                }
            }
        }
        this.myPageValidationResult = result;
        this.myState.setModulesToImport(selectedModules);
        this.updateStatusDisplay(status, validationDetails);
        this.myStatus = status;
        this.myUpdateListener.update();
    }

    private void createUIComponents() {
        this.myValidationProgress = new AsyncProcessIcon("validation");
        this.myValidationProgress.setVisible(false);
    }

    public boolean validate() {
        return this.myStatus.severity != MessageType.ERROR && !this.myValidating && this.myModulesPanel.canImport();
    }

    @Override
    public boolean isValid() {
        return this.validate();
    }

    @NotNull
    protected PathValidationResult checkPath(@NotNull String path) {
        if (Strings.isNullOrEmpty((String)(path = path.trim()))) {
            return PageStatus.EMPTY_PATH.result();
        }
        VirtualFile vfile = VfsUtil.findFileByIoFile((File)new File(path), (boolean)false);
        if (vfile == null || !vfile.exists()) {
            return PageStatus.DOES_NOT_EXIST.result();
        }
        if (this.isProjectOrModule(vfile)) {
            return PageStatus.IS_PROJECT_OR_MODULE.result();
        }
        ModuleImporter kind = ModuleImporter.importerForLocation(this.myContext, vfile);
        if (!kind.isValid()) {
            return PageStatus.NOT_ADT_OR_GRADLE.result();
        }
        return new PathValidationResult(PageStatus.OK, vfile, kind, null);
    }

    private boolean isProjectOrModule(@NotNull VirtualFile dir) {
        Project project = this.myContext.getProject();
        if (project != null) {
            if (dir.equals(project.getBaseDir())) {
                return true;
            }
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                if (!ModuleUtilCore.isModuleDir((Module)module, (VirtualFile)dir)) continue;
                return true;
            }
        }
        return false;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySourceLocation.getTextField();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextField jTextField;
        JLabel jLabel2;
        JLabel jLabel3;
        JBLabel jBLabel;
        ModulesTable modulesTable;
        JBScrollPane jBScrollPane;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourceLocation = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 2, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myModulesScroller = jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel.add((Component)jBScrollPane, new GridConstraints(5, 0, 1, 4, 0, 3, 7, 3, null, null, null));
        this.myModulesPanel = modulesTable = new ModulesTable();
        jBScrollPane.setViewportView((Component)((Object)modulesTable));
        this.myErrorWarning = jBLabel = new JBLabel();
        jBLabel.setText("An error or warning");
        jPanel.add((Component)jBLabel, new GridConstraints(6, 1, 1, 3, 0, 1, 6, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Source directory:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        AsyncProcessIcon asyncProcessIcon = this.myValidationProgress;
        jPanel.add((Component)asyncProcessIcon, new GridConstraints(6, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(7, 2, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myRequiredModulesLabel = jLabel3 = new JLabel();
        jLabel3.setText("Additional required modules:");
        jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 1, new Dimension(-1, 16), new Dimension(-1, 40), new Dimension(-1, 40)));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 2, 1, 2, 0, 2, 1, 3, null, new Dimension(-1, 120), new Dimension(-1, 120)));
        this.myModuleNameLabel = jLabel2 = new JLabel();
        jLabel2.setText("Module name:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myModuleNameField = jTextField = new JTextField();
        jTextField.setColumns(15);
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, new Dimension(150, -1), null));
        this.myPrimaryModuleState = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(2, 3, 1, 1, 8, 0, 6, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private final class PrimaryModuleImportSettings
    implements ModuleImportSettings {
        private PrimaryModuleImportSettings() {
        }

        @Override
        public boolean isModuleSelected() {
            return true;
        }

        @Override
        public void setModuleSelected(boolean selected) {
        }

        @Override
        public String getModuleName() {
            return ImportSourceLocationStep.this.myModuleNameField.getText();
        }

        @Override
        public void setModuleName(String moduleName) {
            if (!Objects.equal((Object)moduleName, (Object)ImportSourceLocationStep.this.myModuleNameField.getText())) {
                ImportSourceLocationStep.this.myModuleNameField.setText(moduleName);
            }
        }

        @Override
        public void setModuleSourcePath(String relativePath) {
        }

        @Override
        public void setCanToggleModuleSelection(boolean b) {
        }

        @Override
        public void setCanRenameModule(boolean canRenameModule) {
            ImportSourceLocationStep.this.myModuleNameField.setEnabled(canRenameModule);
        }

        @Override
        public void setValidationStatus(@Nullable MessageType statusSeverity, @Nullable String statusDescription) {
            ImportSourceLocationStep.this.myPrimaryModuleState.setIcon(statusSeverity == null ? null : statusSeverity.getDefaultIcon());
            ImportSourceLocationStep.this.myPrimaryModuleState.setText(Strings.nullToEmpty((String)statusDescription));
        }

        @Override
        public void setVisible(boolean visible) {
            ImportSourceLocationStep.this.myPrimaryModuleState.setVisible(visible);
            ImportSourceLocationStep.this.myModuleNameField.setVisible(visible);
            ImportSourceLocationStep.this.myModuleNameLabel.setVisible(visible);
        }

        @Override
        public void addActionListener(final ActionListener actionListener) {
            ImportSourceLocationStep.this.myModuleNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 1001, "changed"));
                }
            });
        }
    }

    static final class PathValidationResult {
        @NotNull
        public final PageStatus myStatus;
        @Nullable
        public final VirtualFile myVfile;
        @Nullable
        public final ModuleImporter myImporter;
        @Nullable
        public final Object myDetails;

        private PathValidationResult(@NotNull PageStatus status, @Nullable VirtualFile vfile, @Nullable ModuleImporter importer, @Nullable Object details) {
            this.myStatus = status;
            this.myVfile = vfile;
            this.myImporter = importer;
            this.myDetails = details;
        }
    }

    static enum PageStatus {
        OK(null, null),
        EMPTY_PATH("Path is empty", MessageType.ERROR),
        DOES_NOT_EXIST("Path does not exist", MessageType.ERROR),
        IS_PROJECT_OR_MODULE("This location is already imported", MessageType.ERROR),
        MISSING_SUBPROJECTS("Some projects were not found", MessageType.WARNING),
        NO_MODULES_SELECTED("Select modules to import", MessageType.ERROR),
        NOT_ADT_OR_GRADLE("Specify location of the Gradle or Android Eclipse project", MessageType.ERROR),
        INTERNAL_ERROR("Internal error, please check the IDE log", MessageType.ERROR),
        VALIDATING("Validating", null);

        @Nullable
        public final MessageType severity;
        @Nullable
        private final String message;

        private PageStatus(String message, MessageType severity) {
            this.message = message;
            this.severity = severity;
        }

        public PathValidationResult result() {
            return new PathValidationResult(this, null, null, null);
        }

        @Nullable
        public Icon getIcon() {
            return this.severity == null ? null : this.severity.getDefaultIcon();
        }

        public boolean isSpinnerVisible() {
            return this == VALIDATING;
        }

        public String getMessage(@Nullable Object details) {
            if (this == MISSING_SUBPROJECTS && details instanceof Collection) {
                String message = ImportUIUtil.formatElementListString((Collection)details, "Unable to find sources for subproject %1$s.", "Unable to find sources for subprojects %1$s and %2$s.", "Unable to find sources for %1$s and %2$d more subprojects.");
                return ImportSourceLocationStep.multiLineJLabelText(new String[]{message, "This may result in missing dependencies."});
            }
            return Strings.nullToEmpty((String)this.message);
        }
    }
}

