/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorApiComboBox;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormFactorUtils {
    private static final IdDisplay NO_MATCH = IdDisplay.create((String)"no_match", (String)"No Match");
    public static final String INCLUDE_FORM_FACTOR = "included";
    public static final String ATTR_MODULE_NAME = "projectName";

    @NotNull
    public static ScopedStateStore.Key<FormFactorApiComboBox.AndroidTargetComboBoxItem> getTargetComboBoxKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApi" + "combo", ScopedStateStore.Scope.STEP, FormFactorApiComboBox.AndroidTargetComboBoxItem.class);
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getMinApiLevelKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApiLevel", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    @NotNull
    public static ScopedStateStore.Key<String> getMinApiKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "minApi", ScopedStateStore.Scope.WIZARD, String.class);
    }

    @NotNull
    public static ScopedStateStore.Key<String> getBuildApiKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "buildApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getTargetApiLevelKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "targetApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    @NotNull
    public static ScopedStateStore.Key<String> getTargetApiStringKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "targetApiString", ScopedStateStore.Scope.WIZARD, String.class);
    }

    @NotNull
    public static ScopedStateStore.Key<Integer> getBuildApiLevelKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "buildApi", ScopedStateStore.Scope.WIZARD, Integer.class);
    }

    @NotNull
    public static ScopedStateStore.Key<String> getLanguageLevelKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + "javaVersion", ScopedStateStore.Scope.WIZARD, String.class);
    }

    @NotNull
    public static ScopedStateStore.Key<Boolean> getInclusionKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + INCLUDE_FORM_FACTOR, ScopedStateStore.Scope.WIZARD, Boolean.class);
    }

    @NotNull
    public static ScopedStateStore.Key<String> getModuleNameKey(@NotNull FormFactor formFactor) {
        return ScopedStateStore.createKey(formFactor.id + ATTR_MODULE_NAME, ScopedStateStore.Scope.WIZARD, String.class);
    }

    public static Map<String, Object> scrubFormFactorPrefixes(@NotNull FormFactor formFactor, @NotNull Map<String, Object> values) {
        HashMap toReturn = Maps.newHashMapWithExpectedSize((int)values.size());
        for (String key : values.keySet()) {
            if (key.startsWith(formFactor.id)) {
                toReturn.put(key.substring(formFactor.id.length()), values.get(key));
                continue;
            }
            toReturn.put(key, values.get(key));
        }
        return toReturn;
    }

    public static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        return formFactor.id + "minApi";
    }

    @NotNull
    public static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String name = formFactor.id.replaceAll("[/\\\\?%*:|\"<>!;]", "");
        name = name.replaceAll("\\s", "_");
        return name.toLowerCase();
    }

    public static Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem> getMinSdkComboBoxFilter(final @NotNull FormFactor formFactor, final int minSdkLevel) {
        return new Predicate<FormFactorApiComboBox.AndroidTargetComboBoxItem>(){

            public boolean apply(@Nullable FormFactorApiComboBox.AndroidTargetComboBoxItem input) {
                if (input == null) {
                    return false;
                }
                return FormFactorUtils.doFilter(formFactor, minSdkLevel, SystemImage.DEFAULT_TAG, input.getApiLevel());
            }
        };
    }

    public static Predicate<RepoPackage> getMinSdkPackageFilter(final @NotNull FormFactor formFactor, final int minSdkLevel) {
        return new Predicate<RepoPackage>(){

            public boolean apply(@Nullable RepoPackage input) {
                if (input == null) {
                    return false;
                }
                return FormFactorUtils.filterPkgDesc(input, formFactor, minSdkLevel);
            }
        };
    }

    private static boolean filterPkgDesc(@NotNull RepoPackage p, @NotNull FormFactor formFactor, int minSdkLevel) {
        return FormFactorUtils.isApiType(p) && FormFactorUtils.doFilter(formFactor, minSdkLevel, FormFactorUtils.getTag(p), FormFactorUtils.getFeatureLevel(p));
    }

    private static boolean doFilter(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable IdDisplay tag, int targetSdkLevel) {
        if (!formFactor.getTags().isEmpty() && !formFactor.getTags().contains(tag)) {
            return false;
        }
        if (!formFactor.getApiBlacklist().isEmpty() && formFactor.getApiBlacklist().contains(targetSdkLevel)) {
            return false;
        }
        return targetSdkLevel >= minSdkLevel;
    }

    @Nullable
    public static Icon getFormFactorsImage(JComponent component, boolean requireEmulator) {
        int width = 0;
        int height = 0;
        for (FormFactor formFactor : FormFactor.values()) {
            Icon icon = formFactor.getLargeIcon();
            height = icon.getIconHeight();
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            width += formFactor.getLargeIcon().getIconWidth();
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphics = image.createGraphics();
        int x = 0;
        for (FormFactor formFactor : FormFactor.values()) {
            if (requireEmulator && !formFactor.hasEmulator()) continue;
            Icon icon = formFactor.getLargeIcon();
            icon.paintIcon(component, graphics, x, 0);
            x += icon.getIconWidth();
        }
        if (graphics != null) {
            graphics.dispose();
            return new ImageIcon(image);
        }
        return null;
    }

    public static boolean isApiType(@NotNull RepoPackage repoPackage) {
        return repoPackage.getTypeDetails() instanceof DetailsTypes.ApiDetailsType;
    }

    public static int getFeatureLevel(@NotNull RepoPackage repoPackage) {
        return FormFactorUtils.getAndroidVersion(repoPackage).getFeatureLevel();
    }

    @NotNull
    public static AndroidVersion getAndroidVersion(@NotNull RepoPackage repoPackage) {
        TypeDetails details = repoPackage.getTypeDetails();
        if (details instanceof DetailsTypes.ApiDetailsType) {
            return ((DetailsTypes.ApiDetailsType)details).getAndroidVersion();
        }
        throw new RuntimeException("Could not determine version");
    }

    @Nullable
    public static IdDisplay getTag(@NotNull RepoPackage repoPackage) {
        DetailsTypes.SysImgDetailsType imgDetailsType;
        TypeDetails details = repoPackage.getTypeDetails();
        IdDisplay tag = NO_MATCH;
        if (details instanceof DetailsTypes.AddonDetailsType) {
            tag = ((DetailsTypes.AddonDetailsType)details).getTag();
        }
        if (details instanceof DetailsTypes.SysImgDetailsType && (imgDetailsType = (DetailsTypes.SysImgDetailsType)details).getAbi().equals("x86")) {
            tag = imgDetailsType.getTag();
        }
        return tag;
    }
}

