/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.builder.model.NativeArtifact;
import com.android.builder.model.NativeFile;
import com.android.builder.model.NativeFolder;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.android.tools.idea.navigator.nodes.NativeAndroidSourceDirectoryNode;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.SimpleTextAttributes;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidLibraryNode
extends ProjectViewNode<Collection<NativeArtifact>>
implements DirectoryGroupNode {
    private static final Set<String> HEADER_FILE_EXTENSIONS = ImmutableSet.of((Object)"h", (Object)"hpp", (Object)"hh", (Object)"h++", (Object)"hxx");
    @NotNull
    private final String myNativeLibraryName;
    @NotNull
    private final String myNativeLibraryType;
    @NotNull
    private final Collection<String> mySourceFileExtensions;

    public NativeAndroidLibraryNode(@NotNull Project project, @NotNull String nativeLibraryName, @NotNull String nativeLibraryType, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        super(project, artifacts, settings);
        this.myNativeLibraryName = nativeLibraryName;
        this.myNativeLibraryType = nativeLibraryType;
        this.mySourceFileExtensions = sourceFileExtensions;
    }

    @NotNull
    public static Collection<AbstractTreeNode> getSourceDirectoryNodes(@NotNull Project project, @NotNull Collection<NativeArtifact> artifacts, @NotNull ViewSettings settings, @NotNull Collection<String> sourceFileExtensions) {
        TreeMap<String, RootDirectory> rootDirectories = new TreeMap<String, RootDirectory>();
        for (NativeArtifact artifact : artifacts) {
            NativeAndroidLibraryNode.addSourceFolders(rootDirectories, artifact);
            NativeAndroidLibraryNode.addSourceFiles(rootDirectories, artifact);
        }
        if (rootDirectories.size() > 1) {
            NativeAndroidLibraryNode.groupDirectories(rootDirectories);
        }
        if (rootDirectories.size() > 1) {
            NativeAndroidLibraryNode.mergeDirectories(rootDirectories);
        }
        HashSet fileExtensions = Sets.newHashSetWithExpectedSize((int)(sourceFileExtensions.size() + HEADER_FILE_EXTENSIONS.size()));
        fileExtensions.addAll(sourceFileExtensions);
        fileExtensions.addAll(HEADER_FILE_EXTENSIONS);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList children = Lists.newArrayList();
        for (RootDirectory rootDirectory : rootDirectories.values()) {
            PsiDirectory psiDir = psiManager.findDirectory(rootDirectory.rootDir);
            if (psiDir == null) continue;
            children.add(new NativeAndroidSourceDirectoryNode(project, psiDir, settings, fileExtensions, rootDirectory.sourceFolders, rootDirectory.sourceFiles));
        }
        return children;
    }

    private static void addSourceFolders(TreeMap<String, RootDirectory> rootDirectories, NativeArtifact artifact) {
        for (VirtualFile sourceFolder : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
            String path = sourceFolder.getPath();
            if (rootDirectories.containsKey(path)) continue;
            RootDirectory rootDirectory = new RootDirectory(sourceFolder);
            rootDirectory.sourceFolders.add(sourceFolder);
            rootDirectories.put(path, rootDirectory);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFolders(@NotNull NativeArtifact artifact) {
        ArrayList sourceFolders = Lists.newArrayList();
        for (File headerRoot : artifact.getExportedHeaders()) {
            sourceFolders.add(headerRoot);
        }
        for (NativeFolder sourceFolder : artifact.getSourceFolders()) {
            sourceFolders.add(sourceFolder.getFolderPath());
        }
        return NativeAndroidLibraryNode.convertToVirtualFiles(sourceFolders);
    }

    private static void addSourceFiles(TreeMap<String, RootDirectory> rootDirectories, NativeArtifact artifact) {
        for (VirtualFile sourceFile : NativeAndroidLibraryNode.getSourceFiles(artifact)) {
            VirtualFile sourceFolder = sourceFile.getParent();
            String path = sourceFolder.getPath();
            RootDirectory rootDirectory = rootDirectories.get(path);
            if (rootDirectory == null) {
                rootDirectory = new RootDirectory(sourceFolder);
                rootDirectories.put(path, rootDirectory);
            }
            rootDirectory.sourceFiles.add(sourceFile);
        }
    }

    @NotNull
    private static List<VirtualFile> getSourceFiles(@NotNull NativeArtifact artifact) {
        ArrayList sourceFiles = Lists.newArrayList();
        for (NativeFile sourceFile : artifact.getSourceFiles()) {
            File source = sourceFile.getFilePath();
            sourceFiles.add(source);
            for (String extension : HEADER_FILE_EXTENSIONS) {
                sourceFiles.add(new File(source.getParentFile(), FileUtil.getNameWithoutExtension((File)source) + "." + extension));
            }
        }
        return NativeAndroidLibraryNode.convertToVirtualFiles(sourceFiles);
    }

    @NotNull
    private static List<VirtualFile> convertToVirtualFiles(@NotNull Collection<File> files) {
        ArrayList result = Lists.newArrayListWithCapacity((int)files.size());
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (File file : files) {
            VirtualFile virtualFile = fileSystem.findFileByIoFile(file);
            if (virtualFile == null) continue;
            result.add(virtualFile);
        }
        return result;
    }

    private static void groupDirectories(TreeMap<String, RootDirectory> rootDirectories) {
        String keyToMerge = rootDirectories.lastKey();
        while (keyToMerge != null) {
            RootDirectory dirToMerge = rootDirectories.get(keyToMerge);
            VirtualFile dirToMergeParent = dirToMerge.rootDir.getParent();
            if (dirToMergeParent == null) {
                keyToMerge = rootDirectories.lowerKey(keyToMerge);
                continue;
            }
            RootDirectory targetDir = rootDirectories.get(dirToMergeParent.getPath());
            if (targetDir != null) {
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                rootDirectories.remove(keyToMerge);
                keyToMerge = rootDirectories.lastKey();
                continue;
            }
            String previousKey = rootDirectories.lowerKey(keyToMerge);
            if (previousKey == null) break;
            RootDirectory previousDir = rootDirectories.get(previousKey);
            VirtualFile previousDirParent = previousDir.rootDir.getParent();
            if (previousDirParent != null && previousDirParent.getPath().equals(dirToMergeParent.getPath())) {
                targetDir = rootDirectories.get(dirToMergeParent.getPath());
                if (targetDir == null) {
                    targetDir = new RootDirectory(dirToMergeParent);
                    rootDirectories.put(dirToMergeParent.getPath(), targetDir);
                }
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFolders.addAll(previousDir.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                targetDir.sourceFiles.addAll(previousDir.sourceFiles);
                rootDirectories.remove(keyToMerge);
                rootDirectories.remove(previousKey);
                keyToMerge = rootDirectories.lastKey();
                continue;
            }
            keyToMerge = previousKey;
        }
    }

    private static void mergeDirectories(TreeMap<String, RootDirectory> rootDirectories) {
        String keyToMerge = rootDirectories.lastKey();
        while (keyToMerge != null) {
            VirtualFile dir;
            RootDirectory dirToMerge = rootDirectories.get(keyToMerge);
            for (dir = dirToMerge.rootDir.getParent(); dir != null; dir = dir.getParent()) {
                RootDirectory targetDir = rootDirectories.get(dir.getPath());
                if (targetDir == null) {
                    continue;
                }
                targetDir.sourceFolders.addAll(dirToMerge.sourceFolders);
                targetDir.sourceFiles.addAll(dirToMerge.sourceFiles);
                rootDirectories.remove(keyToMerge);
                keyToMerge = rootDirectories.lastKey();
                break;
            }
            if (rootDirectories.size() <= 1) break;
            if (dir != null) continue;
            keyToMerge = rootDirectories.lowerKey(keyToMerge);
        }
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> sourceDirectoryNodes = NativeAndroidLibraryNode.getSourceDirectoryNodes(this.myProject, this.getArtifacts(), this.getSettings(), this.mySourceFileExtensions);
        if (sourceDirectoryNodes.size() == 1) {
            AbstractTreeNode node = (AbstractTreeNode)Iterables.getOnlyElement(sourceDirectoryNodes);
            assert (node instanceof NativeAndroidSourceDirectoryNode);
            return ((NativeAndroidSourceDirectoryNode)node).getChildren();
        }
        return sourceDirectoryNodes;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myNativeLibraryName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (!this.myNativeLibraryType.isEmpty()) {
            presentation.addText(" (" + this.myNativeLibraryType + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.NativeLibrariesFolder);
    }

    public boolean contains(@NotNull VirtualFile file) {
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile folder : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
                if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)false)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myNativeLibraryType + this.myNativeLibraryName;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myNativeLibraryName + (this.myNativeLibraryType.isEmpty() ? "" : " (" + this.myNativeLibraryType + ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NativeAndroidLibraryNode that = (NativeAndroidLibraryNode)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        int result = super.hashCode();
        for (NativeArtifact artifact : this.getArtifacts()) {
            result = 31 * result + artifact.hashCode();
        }
        return result;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<PsiDirectory> psiDirectories = new ArrayList<PsiDirectory>();
        for (NativeArtifact artifact : this.getArtifacts()) {
            for (VirtualFile f : NativeAndroidLibraryNode.getSourceFolders(artifact)) {
                PsiDirectory dir = psiManager.findDirectory(f);
                if (dir == null) continue;
                psiDirectories.add(dir);
            }
        }
        return psiDirectories.toArray(new PsiDirectory[psiDirectories.size()]);
    }

    @NotNull
    private Collection<NativeArtifact> getArtifacts() {
        Collection artifacts = (Collection)this.getValue();
        assert (artifacts != null);
        return artifacts;
    }

    private static final class RootDirectory {
        @NotNull
        private final VirtualFile rootDir;
        @NotNull
        private final List<VirtualFile> sourceFolders = Lists.newArrayList();
        @NotNull
        private final List<VirtualFile> sourceFiles = Lists.newArrayList();

        public RootDirectory(@NotNull VirtualFile rootDir) {
            this.rootDir = rootDir;
        }
    }
}

