/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.navigator.nodes.ExternalBuildFileNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalBuildFilesGroupNode
extends ProjectViewNode<Project> {
    public ExternalBuildFilesGroupNode(@NotNull Project project, @NotNull ViewSettings viewSettings) {
        super(project, (Object)project, viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        return this.getBuildFilesWithModuleNames().containsKey(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        Map<VirtualFile, String> buildFiles = this.getBuildFilesWithModuleNames();
        ArrayList children = Lists.newArrayListWithExpectedSize((int)buildFiles.size());
        for (Map.Entry<VirtualFile, String> buildFileWithModuleName : buildFiles.entrySet()) {
            this.addPsiFile(children, buildFileWithModuleName.getKey(), buildFileWithModuleName.getValue());
        }
        return children;
    }

    @NotNull
    private Map<VirtualFile, String> getBuildFilesWithModuleNames() {
        HashMap buildFiles = Maps.newHashMap();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            NativeAndroidGradleModel nativeAndroidModel = NativeAndroidGradleModel.get(module);
            if (nativeAndroidModel == null) continue;
            for (File file : nativeAndroidModel.getNativeAndroidProject().getBuildFiles()) {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
                if (virtualFile == null) continue;
                buildFiles.put(virtualFile, module.getName());
            }
        }
        return buildFiles;
    }

    private void addPsiFile(@NotNull List<PsiFileNode> psiFileNodes, @NotNull VirtualFile file, @NotNull String moduleName) {
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile != null) {
            psiFileNodes.add(new ExternalBuildFileNode(this.myProject, psiFile, this.getSettings(), moduleName));
        }
    }

    public int getWeight() {
        return 200;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText("External Build Files");
        presentation.setIcon(AllIcons.General.ExternalToolsSmall);
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return "External Build Files";
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }
}

