/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidBuildScriptsGroupNode;
import com.android.tools.idea.navigator.nodes.AndroidModuleNode;
import com.android.tools.idea.navigator.nodes.ExternalBuildFilesGroupNode;
import com.android.tools.idea.navigator.nodes.NativeAndroidModuleNode;
import com.android.tools.idea.navigator.nodes.NonAndroidModuleNode;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidViewProjectNode
extends ProjectViewNode<Project> {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidViewProjectNode(@NotNull Project project, @NotNull ViewSettings viewSettings, @NotNull AndroidProjectViewPane projectViewPane) {
        super(project, (Object)project, viewSettings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ExternalBuildFilesGroupNode externalBuildFilesNode;
        PsiDirectory dir;
        Project project = this.getProject();
        ViewSettings settings = this.getSettings();
        List<Module> modules = Arrays.asList(ModuleManager.getInstance((Project)project).getModules());
        ArrayList children = Lists.newArrayListWithExpectedSize((int)modules.size());
        for (Module module : modules) {
            if (GradleUtil.isRootModuleWithNoSources(module)) continue;
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NativeAndroidGradleFacet nativeAndroidFacet = NativeAndroidGradleFacet.getInstance(module);
            if (androidFacet != null && androidFacet.getAndroidModel() != null) {
                children.add(new AndroidModuleNode(project, module, settings, this.myProjectViewPane));
                continue;
            }
            if (nativeAndroidFacet != null && nativeAndroidFacet.getNativeAndroidGradleModel() != null) {
                children.add(new NativeAndroidModuleNode(project, module, settings));
                continue;
            }
            children.add(new NonAndroidModuleNode(project, module, settings));
        }
        if (children.isEmpty() && Projects.isBuildWithGradle(project) && Projects.lastGradleSyncFailed(project) && (dir = PsiManager.getInstance((Project)project).findDirectory(project.getBaseDir())) != null) {
            children.add(new PsiDirectoryNode(project, dir, settings));
        }
        if (Projects.isBuildWithGradle(project)) {
            children.add(new AndroidBuildScriptsGroupNode(project, settings));
        }
        if (!(externalBuildFilesNode = new ExternalBuildFilesGroupNode(project, settings)).getChildren().isEmpty()) {
            children.add(externalBuildFilesNode);
        }
        return children;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s", this.getProject().getName());
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    protected void update(PresentationData presentation) {
        presentation.setIcon(PlatformIcons.PROJECT_ICON);
        presentation.setPresentableText(this.getProject().getName());
    }

    public boolean contains(@NotNull VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        VirtualFile baseDir = this.getProject().getBaseDir();
        return index.isInContent(file) || index.isInLibraryClasses(file) || index.isInLibrarySource(file) || baseDir != null && VfsUtilCore.isAncestor((VirtualFile)baseDir, (VirtualFile)file, (boolean)false);
    }
}

