/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.MemoryAxisFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class MemorySegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "Memory";
    private static final BaseAxisFormatter MEMORY_AXIS_FORMATTER = MemoryAxisFormatter.DEFAULT;
    private static final BaseAxisFormatter COUNT_AXIS_FORMATTER = new SingleUnitAxisFormatter(1, 10, 1, "");
    private static final Color MEMORY_TOTAL_COLOR = new JBColor(new Color(123, 170, 214), new Color(123, 170, 214));
    private static final Color MEMORY_NATIVE_COLOR = new JBColor(new Color(132, 209, 199), new Color(132, 209, 199));
    private static final Color MEMORY_GRAPHICS_COLOR = new JBColor(new Color(219, 191, 141), new Color(219, 191, 141));
    private static final Color MEMORY_CODE_COLOR = new JBColor(new Color(125, 206, 132), new Color(125, 206, 132));
    private static final Color MEMORY_OTHER_COLOR = new JBColor(new Color(78, 147, 187), new Color(78, 147, 187));
    private static final Color MEMORY_COUNT_COLOR = new JBColor(new Color(70, 120, 31), new Color(70, 120, 31));

    public MemorySegment(@NotNull Range timeRange, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, timeRange, dataStore, MEMORY_AXIS_FORMATTER, COUNT_AXIS_FORMATTER, dispatcher);
    }

    @Override
    public BaseSegment.SegmentType getSegmentType() {
        return BaseSegment.SegmentType.MEMORY;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        if (isExpanded) {
            this.addMemoryLevelLine(SeriesDataType.MEMORY_JAVA, MEMORY_TOTAL_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_NATIVE, MEMORY_NATIVE_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_GRAPHICS, MEMORY_GRAPHICS_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_CODE, MEMORY_CODE_COLOR);
            this.addMemoryLevelLine(SeriesDataType.MEMORY_OTHERS, MEMORY_OTHER_COLOR);
            this.addLine(SeriesDataType.MEMORY_OBJECT_COUNT, SeriesDataType.MEMORY_OBJECT_COUNT.toString(), new LineConfig(MEMORY_COUNT_COLOR), this.mRightAxisRange);
        } else {
            this.addMemoryLevelLine(SeriesDataType.MEMORY_TOTAL, MEMORY_TOTAL_COLOR);
        }
    }

    private void addMemoryLevelLine(SeriesDataType type, Color color) {
        this.addLine(type, type.toString(), new LineConfig(color).setFilled(true).setStacked(true), this.mLeftAxisRange);
    }
}

