/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.memory.model.MemoryInfoTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class MemoryDetailSegment
extends BaseSegment {
    private static final String SEGMENT_NAME = "Memory Details";
    private static final Color NEGATIVE_COLOR = new JBColor(new Color(0x33FF0000, true), new Color(872375396, true));
    private static final Color POSITIVE_COLOR = new JBColor(new Color(0x330000FF, true), new Color(861445622, true));
    @NotNull
    private final MemoryInfoTreeNode mRoot;
    private JComponent mColumnTree;
    private JTree mTree;
    private DefaultTreeModel mTreeModel;

    public MemoryDetailSegment(@NotNull Range timeRange, @NotNull MemoryInfoTreeNode root, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, timeRange, dispatcher);
        this.mRoot = root;
    }

    public void refreshNode(@NotNull MemoryInfoTreeNode node) {
        this.mTreeModel.reload(node);
    }

    public boolean getExpandState(@NotNull MemoryInfoTreeNode node) {
        return this.mTree.isExpanded(new TreePath(this.mTreeModel.getPathToRoot(node)));
    }

    public void setExpandState(@NotNull MemoryInfoTreeNode node, boolean expand) {
        if (expand) {
            this.mTree.expandPath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        } else {
            this.mTree.collapsePath(new TreePath(this.mTreeModel.getPathToRoot(node)));
        }
    }

    public void insertNode(@NotNull MemoryInfoTreeNode parent, @NotNull MemoryInfoTreeNode child) {
        this.mTreeModel.insertNodeInto(child, parent, parent.getChildCount());
    }

    @Override
    protected boolean hasLeftContent() {
        return false;
    }

    @Override
    protected boolean hasRightContent() {
        return false;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        panel.add((Component)this.mColumnTree, "Center");
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        this.mTreeModel = new DefaultTreeModel(this.mRoot);
        this.mTree = new Tree((TreeModel)this.mTreeModel);
        this.mTree.setRootVisible(false);
        this.mTree.setShowsRootHandles(true);
        ColumnTreeBuilder builder = new ColumnTreeBuilder(this.mTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Class").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(0, this.mRoot))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Count").setHeaderAlignment(2).setRenderer((ColoredTreeCellRenderer)new MemoryInfoColumnRenderer(1, this.mRoot)));
        this.mColumnTree = builder.build();
    }

    private static class MemoryInfoHealthBar
    extends JComponent {
        private float mDelta;
        private float mPercentage;

        private MemoryInfoHealthBar() {
        }

        private void setDelta(float delta) {
            this.mDelta = delta;
        }

        private void setPercentage(float percent) {
            this.mPercentage = percent;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension dim = this.getSize();
            if (this.mDelta > 0.0f) {
                g.setColor(NEGATIVE_COLOR);
            } else {
                g.setColor(POSITIVE_COLOR);
            }
            g.fillRect(0, 0, (int)((float)dim.width * this.mPercentage), dim.height);
        }
    }

    private static class MemoryInfoColumnRenderer
    extends ColoredTreeCellRenderer {
        @NotNull
        private final MemoryInfoHealthBar mHealthBar = new MemoryInfoHealthBar();
        @NotNull
        private final MemoryInfoTreeNode mRoot;
        private final int mColumnIndex;

        private MemoryInfoColumnRenderer(int index, @NotNull MemoryInfoTreeNode root) {
            this.mColumnIndex = index;
            this.mRoot = root;
            if (this.mColumnIndex > 0) {
                this.setLayout(new BorderLayout());
                this.add(this.mHealthBar, "Center");
            }
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MemoryInfoTreeNode) {
                MemoryInfoTreeNode node = (MemoryInfoTreeNode)value;
                switch (this.mColumnIndex) {
                    case 0: {
                        this.append(node.getName());
                        break;
                    }
                    case 1: {
                        this.append(String.valueOf(node.getCount()));
                    }
                }
                if (this.mHealthBar != null) {
                    this.mHealthBar.setDelta((float)node.getCount() / (float)this.mRoot.getCount());
                    this.mHealthBar.setPercentage((float)node.getCount() / (float)this.mRoot.getCount());
                }
            }
        }
    }
}

