/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.events.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.SimpleEventComponent;
import com.android.tools.adtui.StackedEventComponent;
import com.android.tools.adtui.model.EventAction;
import com.android.tools.adtui.model.RangedSimpleSeries;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EventSegment<E extends Enum<E>>
extends BaseSegment {
    private static final String SEGMENT_NAME = "Events";
    private static final int ACTIVITY_GRAPH_SIZE = 25;
    private static final int FRAGMENT_GRAPH_SIZE = 25;
    @NotNull
    private SimpleEventComponent mSystemEvents;
    @NotNull
    private StackedEventComponent mFragmentEvents;
    @NotNull
    private StackedEventComponent mActivityEvents;
    @NotNull
    private final RangedSimpleSeries<EventAction<SimpleEventComponent.Action, E>> mSystemEventData;
    @NotNull
    private final RangedSimpleSeries<EventAction<StackedEventComponent.Action, String>> mFragmentEventData;
    @NotNull
    private final RangedSimpleSeries<EventAction<StackedEventComponent.Action, String>> mActivityEventData;
    @NotNull
    private BufferedImage[] mIcons;

    public EventSegment(@NotNull Range scopedRange, @NotNull RangedSimpleSeries<EventAction<SimpleEventComponent.Action, E>> systemData, @NotNull RangedSimpleSeries<EventAction<StackedEventComponent.Action, String>> fragmentData, @NotNull RangedSimpleSeries<EventAction<StackedEventComponent.Action, String>> activityData, @NotNull BufferedImage[] icons, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, scopedRange, dispatcher);
        this.mSystemEventData = systemData;
        this.mFragmentEventData = fragmentData;
        this.mActivityEventData = activityData;
        this.mIcons = icons;
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        this.mSystemEvents = new SimpleEventComponent(this.mSystemEventData, this.mIcons);
        this.mFragmentEvents = new StackedEventComponent(25, this.mFragmentEventData);
        this.mActivityEvents = new StackedEventComponent(25, this.mActivityEventData);
        animatables.add((Animatable)this.mSystemEvents);
        animatables.add((Animatable)this.mFragmentEvents);
        animatables.add((Animatable)this.mActivityEvents);
    }

    @Override
    public void profilerExpanded(@NotNull BaseSegment.SegmentType segment) {
        this.toggleView(true);
    }

    @Override
    public void profilersReset() {
        this.toggleView(false);
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        JPanel layeredPane = new JPanel();
        layeredPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        layeredPane.add((Component)this.mSystemEvents, gbc);
        gbc.gridy = 1;
        layeredPane.add((Component)this.mFragmentEvents, gbc);
        gbc.gridy = 2;
        layeredPane.add((Component)this.mActivityEvents, gbc);
        panel.add((Component)layeredPane, "Center");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        assert (this.mIcons.length > 0 && this.mIcons[0] != null);
        return new Dimension(size.width, 100 + this.mIcons[0].getHeight());
    }
}

