/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.common.formatter.SingleUnitAxisFormatter;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.BaseLineChartSegment;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class CpuUsageSegment
extends BaseLineChartSegment {
    private static final String SEGMENT_NAME = "CPU";
    private static final String MY_PROCESS_SERIES_LABEL = "My Process";
    private static final String OTHER_PROCESSES_SERIES_LABEL = "Other Processes";
    private static final String THREADS_SERIES_LABEL = "Threads";
    private static final SingleUnitAxisFormatter CPU_USAGE_AXIS = new SingleUnitAxisFormatter(10, 10, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(5, 10, 1, "");
    private static final Color MY_PROCESS_LINE_COLOR = new JBColor(8766608, 8766608);
    private static final Color OTHER_PROCESSES_LINE_COLOR = new JBColor(13228257, 13228257);
    private static final Color THREADS_LINE_COLOR = new JBColor(5935680, 5935680);

    public CpuUsageSegment(@NotNull Range timeRange, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(SEGMENT_NAME, timeRange, dataStore, (BaseAxisFormatter)CPU_USAGE_AXIS, (BaseAxisFormatter)NUM_THREADS_AXIS, new Range(0.0, 100.0), null, dispatcher);
    }

    @Override
    public BaseSegment.SegmentType getSegmentType() {
        return BaseSegment.SegmentType.CPU;
    }

    @Override
    protected void updateChartLines(boolean isExpanded) {
        this.addCpuUsageLine(SeriesDataType.CPU_MY_PROCESS, MY_PROCESS_SERIES_LABEL, MY_PROCESS_LINE_COLOR);
        if (isExpanded) {
            this.addCpuUsageLine(SeriesDataType.CPU_OTHER_PROCESSES, OTHER_PROCESSES_SERIES_LABEL, OTHER_PROCESSES_LINE_COLOR);
            this.addLine(SeriesDataType.CPU_THREADS, THREADS_SERIES_LABEL, new LineConfig(THREADS_LINE_COLOR).setStepped(true), this.mRightAxisRange);
        }
    }

    private void addCpuUsageLine(SeriesDataType type, String label, Color lineColor) {
        this.addLine(type, label, new LineConfig(lineColor).setFilled(true).setStacked(true), this.mLeftAxisRange);
    }
}

