/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.RotatedLabel;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.jetbrains.annotations.NotNull;

public abstract class BaseSegment
extends JComponent
implements ProfilerEventListener {
    private static final int SPACER_WIDTH = 100;
    private static final Border SEGMENT_BORDER = new CompoundBorder(new MatteBorder(0, 0, 1, 0, AdtUiUtils.DEFAULT_BORDER_COLOR), new EmptyBorder(0, 0, 0, 0));
    private static final int LABEL_BORDER_WIDTH = 2;
    private static final Border LABEL_BORDER = new MatteBorder(0, 0, 0, 2, AdtUiUtils.DEFAULT_BORDER_COLOR);
    private JPanel mRightPanel;
    private JPanel mLeftPanel;
    @NotNull
    private RotatedLabel mLabel;
    @NotNull
    protected final String myName;
    @NotNull
    protected Range mXRange;
    @NotNull
    protected final EventDispatcher<ProfilerEventListener> mEventDispatcher;

    public BaseSegment(@NotNull String name, @NotNull Range xRange, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        this.myName = name;
        this.mXRange = xRange;
        this.mEventDispatcher = dispatcher;
        this.mEventDispatcher.addListener((EventListener)this);
    }

    public static int getSpacerWidth() {
        return 100;
    }

    public void initializeComponents() {
        this.setLayout(new BorderLayout());
        FontMetrics metrics = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT);
        JPanel labelPanel = this.createSpacerPanel(metrics.getHeight() + 2);
        labelPanel.setBorder(LABEL_BORDER);
        this.mLabel = new RotatedLabel();
        this.mLabel.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        this.mLabel.setText(this.myName);
        this.mLabel.setBorder(SEGMENT_BORDER);
        labelPanel.add((Component)this.mLabel);
        this.add((Component)labelPanel, "West");
        JBPanel panels = new JBPanel();
        panels.setBorder(SEGMENT_BORDER);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        panels.setLayout((LayoutManager)new GridBagLayout());
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        if (this.hasLeftContent()) {
            this.mLeftPanel = this.createSpacerPanel(BaseSegment.getSpacerWidth());
            gbc.gridx = 0;
            gbc.gridy = 1;
            panels.add((Component)this.mLeftPanel, (Object)gbc);
            this.setLeftContent(this.mLeftPanel);
        }
        JBPanel topPanel = new JBPanel();
        topPanel.setLayout((LayoutManager)new BorderLayout());
        gbc.gridx = 1;
        gbc.gridy = 0;
        panels.add((Component)topPanel, (Object)gbc);
        this.setTopCenterContent((JPanel)topPanel);
        if (this.hasRightContent()) {
            this.mRightPanel = this.createSpacerPanel(BaseSegment.getSpacerWidth());
            gbc.gridx = 2;
            gbc.gridy = 1;
            panels.add((Component)this.mRightPanel, (Object)gbc);
            this.setRightContent(this.mRightPanel);
        }
        JBPanel centerPanel = new JBPanel();
        centerPanel.setLayout((LayoutManager)new BorderLayout());
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        panels.add((Component)centerPanel, (Object)gbc);
        this.setCenterContent((JPanel)centerPanel);
        this.add((Component)panels, "Center");
        this.toggleView(false);
    }

    public int getLabelColumnWidth() {
        return this.mLabel == null ? 2 : this.mLabel.getPreferredSize().width + 2;
    }

    private JPanel createSpacerPanel(int spacerWidth) {
        JBPanel panel = new JBPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        Dimension spacerDimension = new Dimension(spacerWidth, 0);
        panel.setPreferredSize(spacerDimension);
        panel.setMinimumSize(spacerDimension);
        return panel;
    }

    public void setRightSpacerVisible(boolean isVisible) {
        if (this.hasRightContent()) {
            this.mRightPanel.setVisible(isVisible);
        }
    }

    public boolean isRightSpacerVisible() {
        return this.hasRightContent() && this.mRightPanel.isVisible();
    }

    public void setLeftSpacerVisible(boolean isVisible) {
        if (this.hasLeftContent()) {
            this.mLeftPanel.setVisible(isVisible);
        }
    }

    public boolean isLeftSpacerVisible() {
        return this.hasLeftContent() && this.mLeftPanel.isVisible();
    }

    public void toggleView(boolean isExpanded) {
        this.setRightSpacerVisible(isExpanded);
    }

    public void createComponentsList(@NotNull List<Animatable> animatables) {
    }

    protected boolean hasLeftContent() {
        return true;
    }

    protected void setLeftContent(@NotNull JPanel panel) {
    }

    protected abstract void setCenterContent(@NotNull JPanel var1);

    protected boolean hasRightContent() {
        return true;
    }

    protected void setRightContent(@NotNull JPanel panel) {
    }

    protected void setTopCenterContent(@NotNull JPanel panel) {
    }

    public static enum SegmentType {
        TIME,
        EVENT,
        NETWORK,
        MEMORY,
        CPU,
        GPU,
        THREADS;

    }
}

