/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.GridComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.Range;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.LegendRenderData;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.adtui.model.ReportingSeries;
import com.android.tools.idea.monitor.datastore.DataStoreSeries;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.ProfilerEventListener;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLineChartSegment
extends BaseSegment {
    private static final int MULTI_CLICK_INTERVAL_MS = 300;
    private static final int MOUSE_DRAG_DISTANCE_THRESHOLD_PX = 5;
    private static final int MULTI_CLICK_THRESHOLD = 2;
    @NotNull
    protected Range mLeftAxisRange;
    @Nullable
    protected Range mRightAxisRange;
    private AxisComponent mLeftAxis;
    private AxisComponent mRightAxis;
    private final BaseAxisFormatter mLeftAxisFormatter;
    private final BaseAxisFormatter mRightAxisFormatter;
    private GridComponent mGrid;
    private LineChart mLineChart;
    protected LegendComponent mLegendComponent;
    @NotNull
    protected SeriesDataStore mSeriesDataStore;
    private final ArrayDeque<MouseEvent> mDelayedEvents;
    private boolean mMultiClicked;
    private Point mMousePressedPosition;

    public BaseLineChartSegment(@NotNull String name, @NotNull Range xRange, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @Nullable Range leftAxisRange, @Nullable Range rightAxisRange, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        super(name, xRange, dispatcher);
        this.mLeftAxisFormatter = leftAxisFormatter;
        this.mRightAxisFormatter = rightAxisFormatter;
        this.mLeftAxisRange = leftAxisRange != null ? leftAxisRange : new Range();
        this.mSeriesDataStore = dataStore;
        if (this.mRightAxisFormatter != null) {
            this.mRightAxisRange = rightAxisRange != null ? rightAxisRange : new Range();
        }
        this.mDelayedEvents = new ArrayDeque();
        this.initializeListeners();
    }

    public BaseLineChartSegment(@NotNull String name, @NotNull Range xRange, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        this(name, xRange, dataStore, leftAxisFormatter, rightAxisFormatter, null, null, dispatcher);
    }

    public abstract BaseSegment.SegmentType getSegmentType();

    @Override
    public void profilerExpanded(@NotNull BaseSegment.SegmentType segmentType) {
        if (this.getSegmentType() == segmentType) {
            this.toggleView(true);
        }
    }

    @Override
    public void profilersReset() {
        this.toggleView(false);
    }

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        this.mLeftAxis = new AxisComponent(this.mLeftAxisRange, this.mLeftAxisRange, "", AxisComponent.AxisOrientation.LEFT, 0, 0, true, this.mLeftAxisFormatter);
        this.mLeftAxis.setClampToMajorTicks(true);
        if (this.mRightAxisRange != null) {
            this.mRightAxis = new AxisComponent(this.mRightAxisRange, this.mRightAxisRange, "", AxisComponent.AxisOrientation.RIGHT, 0, 0, true, this.mRightAxisFormatter);
            this.mRightAxis.setParentAxis(this.mLeftAxis);
        }
        this.mLineChart = new LineChart();
        this.mGrid = new GridComponent();
        this.mGrid.addAxis(this.mLeftAxis);
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, 100);
        animatables.add((Animatable)this.mLineChart);
        animatables.add((Animatable)this.mLeftAxis);
        if (this.mRightAxis != null) {
            animatables.add((Animatable)this.mRightAxis);
        }
        animatables.add((Animatable)this.mLeftAxisRange);
        if (this.mRightAxisRange != null) {
            animatables.add((Animatable)this.mRightAxisRange);
        }
        animatables.add((Animatable)this.mLegendComponent);
        animatables.add((Animatable)this.mGrid);
    }

    @Override
    protected void setLeftContent(@NotNull JPanel panel) {
        panel.add((Component)this.mLeftAxis, "Center");
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        JBLayeredPane layeredPane = new JBLayeredPane();
        layeredPane.add((Component)this.mLineChart);
        layeredPane.add((Component)this.mGrid);
        layeredPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        panel.add((Component)layeredPane, "Center");
    }

    @Override
    protected void setRightContent(@NotNull JPanel panel) {
        if (this.mRightAxis != null) {
            panel.add((Component)this.mRightAxis, "Center");
            this.setRightSpacerVisible(true);
        } else {
            this.setRightSpacerVisible(false);
        }
    }

    private void initializeListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseLineChartSegment.this.mMousePressedPosition = e.getPoint();
                if (e.getClickCount() >= 2 && !BaseLineChartSegment.this.mDelayedEvents.isEmpty()) {
                    BaseLineChartSegment.this.mMultiClicked = true;
                    ((ProfilerEventListener)BaseLineChartSegment.this.mEventDispatcher.getMulticaster()).profilerExpanded(BaseLineChartSegment.this.getSegmentType());
                } else {
                    BaseLineChartSegment.this.mMultiClicked = false;
                    BaseLineChartSegment.this.mDelayedEvents.add(e);
                    Timer dispatchTimer = new Timer(300, e1 -> BaseLineChartSegment.this.dispatchOrAbsorbEvents());
                    dispatchTimer.setRepeats(false);
                    dispatchTimer.start();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double distance;
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
                if (!BaseLineChartSegment.this.mDelayedEvents.isEmpty() && (distance = Point.distance(BaseLineChartSegment.this.mMousePressedPosition.getX(), BaseLineChartSegment.this.mMousePressedPosition.getY(), e.getPoint().getX(), e.getPoint().getY())) > 5.0) {
                    BaseLineChartSegment.this.dispatchOrAbsorbEvents();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
    }

    private void dispatchOrDelayEvent(MouseEvent e) {
        if (this.mDelayedEvents.isEmpty()) {
            this.getParent().dispatchEvent(e);
        } else {
            this.mDelayedEvents.addLast(e);
        }
    }

    private void dispatchOrAbsorbEvents() {
        if (this.mMultiClicked) {
            this.mDelayedEvents.clear();
        } else {
            while (!this.mDelayedEvents.isEmpty()) {
                this.getParent().dispatchEvent(this.mDelayedEvents.remove());
            }
        }
    }

    @Override
    public void toggleView(boolean isExpanded) {
        super.toggleView(isExpanded);
        this.mLineChart.clearLineConfigs();
        this.updateChartLines(isExpanded);
        this.mLegendComponent.setLegendData(this.getLegendRenderDataList());
    }

    protected abstract void updateChartLines(boolean var1);

    private List<LegendRenderData> getLegendRenderDataList() {
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        for (RangedContinuousSeries series : this.mLineChart.getRangedContinuousSeries()) {
            LineConfig lineConfig = this.mLineChart.getLineConfig(series);
            LegendRenderData.IconType iconType = lineConfig.isFilled() ? LegendRenderData.IconType.BOX : LegendRenderData.IconType.LINE;
            legendRenderDataList.add(new LegendRenderData(iconType, lineConfig.getColor(), (ReportingSeries)series));
        }
        return legendRenderDataList;
    }

    protected void addLine(SeriesDataType type, String label, LineConfig lineConfig, Range yRange) {
        this.mLineChart.addLine(new RangedContinuousSeries(label, this.mXRange, yRange, new DataStoreSeries(this.mSeriesDataStore, type)), lineConfig);
    }
}

