/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.profilerclient;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.monitor.profilerclient.DeviceProfilerService;
import com.android.tools.profiler.proto.ProfilerService;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerService {
    private static final String EXPECTED_VERSION = "15.1.876456";
    private static final Logger LOG = Logger.getInstance((String)ProfilerService.class.getCanonicalName());
    @NotNull
    private final Map<IDevice, DeviceProfilerService> myDeviceClientServices = new HashMap<IDevice, DeviceProfilerService>();

    @NotNull
    public static ProfilerService getInstance() {
        return (ProfilerService)ServiceManager.getService(ProfilerService.class);
    }

    @Nullable
    public synchronized DeviceProfilerService connect(@NotNull Object userKey, @NotNull IDevice device) {
        String versionResponse;
        if (device.getState() != IDevice.DeviceState.ONLINE) {
            return null;
        }
        if (this.myDeviceClientServices.containsKey(device)) {
            DeviceProfilerService deviceProfilerService = this.myDeviceClientServices.get(device);
            deviceProfilerService.register(userKey);
            return deviceProfilerService;
        }
        DeviceProfilerService deviceProfilerService = DeviceProfilerService.createService(device);
        if (deviceProfilerService == null) {
            return null;
        }
        this.myDeviceClientServices.put(device, deviceProfilerService);
        deviceProfilerService.register(userKey);
        try {
            versionResponse = deviceProfilerService.getDeviceService().getVersion(ProfilerService.VersionRequest.getDefaultInstance()).getVersion();
        }
        catch (RuntimeException e) {
            LOG.info("Error connecting to profiler server: " + e.toString());
            this.disconnect(userKey, deviceProfilerService);
            return null;
        }
        if (!versionResponse.equals(EXPECTED_VERSION)) {
            LOG.info("Device '" + device.getAvdName() + "' did not return the expected version. Expected: " + EXPECTED_VERSION + ", received: " + versionResponse + ".");
            this.disconnect(userKey, deviceProfilerService);
            return null;
        }
        return deviceProfilerService;
    }

    public void disconnect(@NotNull Object userKey, @NotNull DeviceProfilerService deviceProfilerService) {
        if (deviceProfilerService.unregister(userKey)) {
            this.myDeviceClientServices.remove(deviceProfilerService.getDevice());
        }
    }

    synchronized void stop(@NotNull DeviceProfilerService deviceProfilerService) {
        this.myDeviceClientServices.remove(deviceProfilerService.getDevice());
    }
}

