/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.datastore;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.idea.monitor.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.datastore.SeriesDataType;
import com.intellij.util.containers.ImmutableList;
import org.jetbrains.annotations.NotNull;

public class DataStoreSeries<E>
implements DataSeries<E> {
    @NotNull
    private final SeriesDataStore mStore;
    @NotNull
    private final SeriesDataType mType;

    public DataStoreSeries(@NotNull SeriesDataStore store, @NotNull SeriesDataType type) {
        this.mStore = store;
        this.mType = type;
    }

    @NotNull
    public SeriesDataType getSeriesType() {
        return this.mType;
    }

    public ImmutableList<SeriesData<E>> getDataForXRange(@NotNull Range xRange) {
        return this.mStore.getSeriesData(this.mType, xRange);
    }

    public SeriesData<E> getDataAtXValue(long x) {
        int index = this.mStore.getClosestTimeIndex(this.mType, x);
        SeriesData data = new SeriesData();
        data.x = this.mStore.getTimeAtIndex(this.mType, index);
        data.value = this.mStore.getValueAtIndex(this.mType, index);
        return data;
    }
}

