/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderResolver {
    public static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    private final ImmutableMap<String, Object> myPlaceholders;

    public ManifestPlaceholderResolver(@NotNull Module module) {
        AndroidGradleModel model = AndroidGradleModel.get(module);
        if (model != null) {
            ImmutableMap.Builder placeholdersBuilder = ImmutableMap.builder();
            Variant selectedVariant = model.getSelectedVariant();
            BuildTypeContainer buildType = model.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                placeholdersBuilder.putAll(buildType.getBuildType().getManifestPlaceholders());
            }
            placeholdersBuilder.putAll(selectedVariant.getMergedFlavor().getManifestPlaceholders());
            this.myPlaceholders = placeholdersBuilder.build();
        } else {
            this.myPlaceholders = ImmutableMap.of();
        }
    }

    @NotNull
    public ImmutableMap<String, Object> getPlaceholders() {
        return this.myPlaceholders;
    }

    @Nullable
    public String resolve(@Nullable String value) {
        if (value == null) {
            return null;
        }
        if (this.myPlaceholders.isEmpty() || !value.contains("${")) {
            return value;
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value);
        while (matcher.find()) {
            Object placeholderValue = this.myPlaceholders.get((Object)matcher.group(1));
            matcher.appendReplacement(output, placeholderValue != null ? Matcher.quoteReplacement(placeholderValue.toString()) : "$0");
        }
        matcher.appendTail(output);
        return output.toString();
    }
}

