/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.MergedManifest;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleInfo {
    @NotNull
    private final AndroidFacet myFacet;

    private AndroidModuleInfo(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
    }

    @NotNull
    public static AndroidModuleInfo create(@NotNull AndroidFacet facet) {
        return new AndroidModuleInfo(facet);
    }

    @NotNull
    public static AndroidModuleInfo get(@NotNull AndroidFacet facet) {
        return facet.getAndroidModuleInfo();
    }

    @Nullable
    public static AndroidModuleInfo get(@NotNull Module module) {
        AndroidFacet facet = AndroidFacet.getInstance(module);
        return facet != null ? facet.getAndroidModuleInfo() : null;
    }

    @Nullable
    public String getPackage() {
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null) {
            return androidModel.getApplicationId();
        }
        return MergedManifest.get(this.myFacet).getApplicationId();
    }

    @NotNull
    public AndroidVersion getRuntimeMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getRuntimeMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return MergedManifest.get(this.myFacet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion minSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (minSdkVersion = androidModel.getMinSdkVersion()) != null) {
            return minSdkVersion;
        }
        return MergedManifest.get(this.myFacet).getMinSdkVersion();
    }

    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion targetSdkVersion;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (targetSdkVersion = androidModel.getTargetSdkVersion()) != null) {
            return targetSdkVersion;
        }
        return MergedManifest.get(this.myFacet).getTargetSdkVersion();
    }

    @Nullable
    public AndroidVersion getBuildSdkVersion() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myFacet.getModule());
        if (platform != null) {
            return platform.getApiVersion();
        }
        return null;
    }

    @Nullable
    public Boolean isDebuggable() {
        Boolean debuggable;
        AndroidModel androidModel = this.myFacet.getAndroidModel();
        if (androidModel != null && (debuggable = androidModel.isDebuggable()) != null) {
            return debuggable;
        }
        return MergedManifest.get(this.myFacet).getApplicationDebuggable();
    }

    @Nullable
    public static AndroidVersion getBuildSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getBuildSdkVersion();
        }
        return null;
    }

    public static int getBuildSdkApiLevel(@Nullable Module module) {
        AndroidVersion version = AndroidModuleInfo.getBuildSdkVersion(module);
        return version != null ? version.getApiLevel() : -1;
    }

    @NotNull
    public static AndroidVersion getTargetSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getTargetSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }

    @NotNull
    public static AndroidVersion getMinSdkVersion(@Nullable Module module) {
        AndroidModuleInfo moduleInfo;
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (moduleInfo = AndroidModuleInfo.get(facet.getModule())) != null) {
            return moduleInfo.getMinSdkVersion();
        }
        return AndroidVersion.DEFAULT;
    }
}

