/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultAndroidLogcatFilter
implements AndroidLogcatFilter {
    @NotNull
    private final String myName;
    @Nullable
    private final Pattern myMessagePattern;
    @Nullable
    private final Pattern myTagPattern;
    @Nullable
    private final Pattern myPkgNamePattern;
    @Nullable
    private final String myPid;
    @Nullable
    private final Log.LogLevel myLogLevel;

    private DefaultAndroidLogcatFilter(@NotNull String name, @Nullable Pattern messagePattern, @Nullable Pattern tagPattern, @Nullable Pattern pkgNamePattern, @Nullable String pid, @Nullable Log.LogLevel logLevel) {
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
    }

    @Override
    public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String pkg, int pid, @NotNull Log.LogLevel logLevel) {
        if (this.myLogLevel != null && logLevel.getPriority() < this.myLogLevel.getPriority()) {
            return false;
        }
        if (this.myMessagePattern != null && !this.myMessagePattern.matcher(message).find()) {
            return false;
        }
        if (this.myTagPattern != null && !this.myTagPattern.matcher(tag).find()) {
            return false;
        }
        if (this.myPkgNamePattern != null && !this.myPkgNamePattern.matcher(pkg).find()) {
            return false;
        }
        return this.myPid == null || this.myPid.length() <= 0 || this.myPid.equals(Integer.toString(pid));
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public static DefaultAndroidLogcatFilter compile(@NotNull PersistentAndroidLogFilters.FilterData filterData, @NotNull String name) {
        Pattern logMessagePattern = RegexFilterComponent.pattern(filterData.getLogMessagePattern(), filterData.getLogMessageIsRegex());
        Pattern logTagPattern = RegexFilterComponent.pattern(filterData.getLogTagPattern(), filterData.getLogTagIsRegex());
        Pattern pkgNamePattern = RegexFilterComponent.pattern(filterData.getPackageNamePattern(), filterData.getPackageNameIsRegex());
        String pid = filterData.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = filterData.getLogLevel();
        if (logLevelStr != null && logLevelStr.length() > 0) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        return new DefaultAndroidLogcatFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel);
    }

    public static final class Builder {
        @NotNull
        private final String myName;
        @Nullable
        private Pattern myMessagePattern;
        @Nullable
        private Pattern myTagPattern;
        @Nullable
        private Pattern myPkgNamePattern;
        @Nullable
        private String myPid;
        @Nullable
        private Log.LogLevel myLogLevel;

        public Builder(@NotNull String name) {
            this.myName = name;
        }

        public Builder setMessagePattern(@Nullable Pattern messagePattern) {
            this.myMessagePattern = messagePattern;
            return this;
        }

        public Builder setTagPattern(@Nullable Pattern tagPattern) {
            this.myTagPattern = tagPattern;
            return this;
        }

        public Builder setPackagePattern(@Nullable Pattern pkgNamePattern) {
            this.myPkgNamePattern = pkgNamePattern;
            return this;
        }

        public Builder setPid(@Nullable String pid) {
            this.myPid = pid;
            return this;
        }

        public Builder setPid(@Nullable Integer pid) {
            return this.setPid(pid != null ? pid.toString() : null);
        }

        public Builder setLogLevel(@Nullable Log.LogLevel logLevel) {
            this.myLogLevel = logLevel;
            return this;
        }

        @NotNull
        public DefaultAndroidLogcatFilter build() {
            return new DefaultAndroidLogcatFilter(this.myName, this.myMessagePattern, this.myTagPattern, this.myPkgNamePattern, this.myPid, this.myLogLevel);
        }
    }
}

