/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lang.databinding.model;

import android.databinding.Bindable;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelField;
import com.android.tools.idea.lang.databinding.model.PsiModelClass;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NotNull;

public class PsiModelField
extends ModelField {
    private static final String BINDABLE_CLASS_NAME = Bindable.class.getName();
    @NotNull
    PsiField myPsiField;

    public PsiModelField(@NotNull PsiField psiField) {
        this.myPsiField = psiField;
    }

    @NotNull
    public PsiField getPsiField() {
        return this.myPsiField;
    }

    public boolean isBindable() {
        PsiModifierList modifierList = this.myPsiField.getModifierList();
        if (modifierList != null) {
            PsiAnnotation[] annotations;
            for (PsiAnnotation annotation : annotations = modifierList.getAnnotations()) {
                if (!BINDABLE_CLASS_NAME.equals(annotation.getQualifiedName())) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return this.myPsiField.getName();
    }

    public boolean isPublic() {
        return this.myPsiField.hasModifierProperty("public");
    }

    public boolean isStatic() {
        return this.myPsiField.hasModifierProperty("static");
    }

    public boolean isFinal() {
        return this.myPsiField.hasModifierProperty("final");
    }

    public ModelClass getFieldType() {
        return new PsiModelClass(this.myPsiField.getType());
    }
}

