/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.NativeAndroidGradleModel;
import com.android.tools.idea.gradle.customizer.ModuleCustomizer;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacet;
import com.android.tools.idea.gradle.facet.NativeAndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.project.PostProjectSetupTasksExecutor;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantModuleCustomizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);

    BuildVariantUpdater() {
    }

    boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        ArrayList affectedAndroidFacets = Lists.newArrayList();
        ArrayList affectedNativeAndroidFacets = Lists.newArrayList();
        Projects.executeProjectChanges(project, () -> {
            Module updatedModule = this.doUpdate(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNativeAndroidFacets);
            if (updatedModule != null) {
                ConflictSet conflicts = ConflictSet.findConflicts(project);
                conflicts.showSelectionConflicts();
            }
            PostProjectSetupTasksExecutor executor = PostProjectSetupTasksExecutor.getInstance(project);
            executor.setGenerateSourcesAfterSync(false, false);
            executor.onProjectSyncCompletion();
            BuildVariantUpdater.generateSourcesIfNeeded(affectedAndroidFacets);
        });
        return !affectedAndroidFacets.isEmpty() || !affectedNativeAndroidFacets.isEmpty();
    }

    @Nullable
    private Module doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NativeAndroidGradleFacet> affectedNativeAndroidFacets) {
        NativeAndroidGradleModel nativeAndroidModel;
        Module moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName);
        if (moduleToUpdate == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NativeAndroidGradleFacet nativeAndroidFacet = NativeAndroidGradleFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && nativeAndroidFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variant, msg);
        }
        if (nativeAndroidFacet != null && BuildVariantUpdater.updateSelectedVariant(nativeAndroidFacet, variant, nativeAndroidModel = BuildVariantUpdater.getNativeAndroidModel(nativeAndroidFacet, variant))) {
            affectedNativeAndroidFacets.add(nativeAndroidFacet);
        }
        if (androidFacet != null) {
            AndroidGradleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null || !this.updateSelectedVariant(androidModel, androidFacet, variant, affectedAndroidFacets)) {
                return null;
            }
            affectedAndroidFacets.add(androidFacet);
        }
        return moduleToUpdate;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private static boolean updateSelectedVariant(@NotNull NativeAndroidGradleFacet nativeAndroidFacet, @NotNull String variantToSelect, @Nullable NativeAndroidGradleModel nativeAndroidModel) {
        ((NativeAndroidGradleFacetConfiguration)nativeAndroidFacet.getConfiguration()).SELECTED_BUILD_VARIANT = variantToSelect;
        if (nativeAndroidModel != null) {
            NativeAndroidGradleModel.NativeVariant selectedVariant = nativeAndroidModel.getSelectedVariant();
            if (variantToSelect.equals(selectedVariant.getName())) {
                return false;
            }
            nativeAndroidModel.setSelectedVariantName(variantToSelect);
            BuildVariantUpdater.invokeCustomizers(nativeAndroidFacet.getModule(), nativeAndroidModel);
            return true;
        }
        return false;
    }

    private boolean updateSelectedVariant(@NotNull AndroidGradleModel androidModel, @NotNull AndroidFacet androidFacet, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        Variant selectedVariant = androidModel.getSelectedVariant();
        if (variantToSelect.equals(selectedVariant.getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = BuildVariantUpdater.invokeCustomizers(androidFacet.getModule(), androidModel);
        for (AndroidLibrary library : androidModel.getSelectedMainCompileDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull List<AndroidFacet> affectedFacets) {
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = affectedFacets.get(0).getModule().getProject();
            GradleProjectBuilder.getInstance(project).generateSourcesOnly(false);
        }
    }

    @NotNull
    private static Module invokeCustomizers(@NotNull Module module, @NotNull AndroidGradleModel androidModel) {
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (ModuleCustomizer moduleCustomizer : BuildVariantUpdater.getCustomizers(androidModel.getProjectSystemId())) {
                moduleCustomizer.customizeModule(module.getProject(), module, (IdeModifiableModelsProvider)modelsProvider, androidModel);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return module;
    }

    @NotNull
    private static List<BuildVariantModuleCustomizer<AndroidGradleModel>> getCustomizers(@NotNull ProjectSystemId targetProjectSystemId) {
        return BuildVariantUpdater.getCustomizers(targetProjectSystemId, (BuildVariantModuleCustomizer[])BuildVariantModuleCustomizer.EP_NAME.getExtensions());
    }

    @VisibleForTesting
    @NotNull
    static List<BuildVariantModuleCustomizer<AndroidGradleModel>> getCustomizers(@NotNull ProjectSystemId targetProjectSystemId, BuildVariantModuleCustomizer ... allCustomizers) {
        ArrayList customizers = Lists.newArrayList();
        for (BuildVariantModuleCustomizer customizer : allCustomizers) {
            ProjectSystemId projectSystemId;
            if (!AndroidGradleModel.class.isAssignableFrom(customizer.getSupportedModelType()) || !Objects.equal((Object)(projectSystemId = customizer.getProjectSystemId()), (Object)targetProjectSystemId) && !Objects.equal((Object)projectSystemId, (Object)ProjectSystemId.IDE)) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    @NotNull
    private static Module invokeCustomizers(@NotNull Module module, @NotNull NativeAndroidGradleModel nativeAndroidModel) {
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (ModuleCustomizer moduleCustomizer : BuildVariantUpdater.getNativeAndroidCustomizers(nativeAndroidModel.getProjectSystemId())) {
                moduleCustomizer.customizeModule(module.getProject(), module, (IdeModifiableModelsProvider)modelsProvider, nativeAndroidModel);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        return module;
    }

    @NotNull
    private static List<BuildVariantModuleCustomizer<NativeAndroidGradleModel>> getNativeAndroidCustomizers(@NotNull ProjectSystemId targetProjectSystemId) {
        return BuildVariantUpdater.getNativeAndroidCustomizers(targetProjectSystemId, (BuildVariantModuleCustomizer[])BuildVariantModuleCustomizer.EP_NAME.getExtensions());
    }

    @VisibleForTesting
    @NotNull
    static List<BuildVariantModuleCustomizer<NativeAndroidGradleModel>> getNativeAndroidCustomizers(@NotNull ProjectSystemId targetProjectSystemId, BuildVariantModuleCustomizer ... allCustomizers) {
        ArrayList customizers = Lists.newArrayList();
        for (BuildVariantModuleCustomizer customizer : allCustomizers) {
            ProjectSystemId projectSystemId;
            if (!NativeAndroidGradleModel.class.isAssignableFrom(customizer.getSupportedModelType()) || !Objects.equal((Object)(projectSystemId = customizer.getProjectSystemId()), (Object)targetProjectSystemId) && !Objects.equal((Object)projectSystemId, (Object)ProjectSystemId.IDE)) continue;
            customizers.add(customizer);
        }
        return customizers;
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        Module module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath);
        if (module == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
            return;
        }
        AndroidGradleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(androidModel, facet, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidGradleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        AndroidGradleModel androidModel = AndroidGradleModel.get(facet);
        if (androidModel == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NativeAndroidGradleModel getNativeAndroidModel(@NotNull NativeAndroidGradleFacet facet, @NotNull String variantToSelect) {
        NativeAndroidGradleModel nativeAndroidModel = NativeAndroidGradleModel.get(facet);
        if (nativeAndroidModel == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return nativeAndroidModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }
}

