/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.testing;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.SourceProvider;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.customizer.dependency.Dependency;
import com.android.tools.idea.gradle.customizer.dependency.DependencySet;
import com.android.tools.idea.gradle.testing.ExcludedModules;
import com.android.tools.idea.gradle.testing.ExcludedRoots;
import com.android.tools.idea.gradle.testing.FileRootSearchScope;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (Projects.lastGradleSyncFailed(project)) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScopes(@NotNull Project project) {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            AndroidGradleModel androidModel = AndroidGradleModel.get(module);
            TestArtifactSearchScopes scopes = androidModel != null ? new TestArtifactSearchScopes(module) : null;
            module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
        }
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        return this.myAndroidTestSourceScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        return this.myUnitTestSourceScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        Set<File> roots = Collections.emptySet();
        AndroidGradleModel androidModel = this.getAndroidModel();
        if (androidModel != null) {
            roots = new HashSet();
            for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
            }
        }
        return new FileRootSearchScope(this.myModule.getProject(), roots);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        return this.myAndroidTestExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        return this.myUnitTestExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        return this.mySharedTestsExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        return this.myAndroidTestDependencyExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        return this.myUnitTestDependencyExcludeScope;
    }

    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        AndroidGradleModel androidModel = this.getAndroidModel();
        if (androidModel == null) {
            return new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
        }
        DependencySet mainDependencies = TestArtifactSearchScopes.extractMainDependencies(androidModel);
        DependencySet androidTestDependencies = TestArtifactSearchScopes.extractAndroidTestDependencies(androidModel);
        DependencySet unitTestDependencies = TestArtifactSearchScopes.extractUnitTestDependencies(androidModel);
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        DependencySet dependenciesToInclude = isAndroidTest ? androidTestDependencies : unitTestDependencies;
        DependencySet dependenciesToExclude = isAndroidTest ? unitTestDependencies : androidTestDependencies;
        ExcludedModules excludedModules = new ExcludedModules(this.myModule);
        excludedModules.add(dependenciesToExclude);
        excludedModules.remove(dependenciesToInclude);
        excludedModules.remove(mainDependencies);
        ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
        excludedRoots.removeLibraryPaths(mainDependencies);
        return new FileRootSearchScope(this.myModule.getProject(), excludedRoots.get());
    }

    @NotNull
    private static DependencySet extractUnitTestDependencies(@NotNull AndroidGradleModel androidModel) {
        JavaArtifact artifact = androidModel.getUnitTestArtifactInSelectedVariant();
        return TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
    }

    @NotNull
    private static DependencySet extractAndroidTestDependencies(@NotNull AndroidGradleModel androidModel) {
        AndroidArtifact artifact = androidModel.getAndroidTestArtifactInSelectedVariant();
        return TestArtifactSearchScopes.extractTestDependencies((BaseArtifact)artifact, androidModel.getModelVersion());
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        return TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact, modelVersion);
    }

    @NotNull
    private static DependencySet extractMainDependencies(AndroidGradleModel androidModel) {
        return TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, (BaseArtifact)androidModel.getMainArtifact(), androidModel.getModelVersion());
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable BaseArtifact artifact, @Nullable GradleVersion modelVersion) {
        return artifact != null ? Dependency.extractFrom(artifact, scope, modelVersion) : DependencySet.EMPTY;
    }

    @Nullable
    private AndroidGradleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidGradleModel.get(this.myModule);
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }
}

