/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.google.common.base.Joiner;
import org.jetbrains.annotations.NotNull;

public class PsLibraryDependencyVersionQuickFixPath
extends PsPath {
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myDependency;
    @NotNull
    private final String myVersion;
    @NotNull
    private String myHrefText = "[Fix]";

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency) {
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        String version = dependency.getResolvedSpec().version;
        assert (version != null);
        this.myVersion = version;
    }

    public PsLibraryDependencyVersionQuickFixPath(@NotNull PsLibraryDependency dependency, @NotNull String version) {
        this.myModuleName = dependency.getParent().getName();
        this.myDependency = PsLibraryDependencyVersionQuickFixPath.getCompactNotation(dependency);
        this.myVersion = version;
    }

    @NotNull
    private static String getCompactNotation(@NotNull PsLibraryDependency dependency) {
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec == null) {
            spec = dependency.getResolvedSpec();
        }
        return spec.compactNotation();
    }

    @Override
    @NotNull
    public String toText(@NotNull PsPath.TexType type) {
        if (type == PsPath.TexType.HTML) {
            return this.getHtmlText();
        }
        return this.myDependency;
    }

    public void setHrefText(@NotNull String hrefText) {
        this.myHrefText = hrefText;
    }

    @NotNull
    private String getHtmlText() {
        String path = Joiner.on((char)'/').join((Object)"setLibraryDependency", (Object)this.myModuleName, new Object[]{this.myDependency, this.myVersion});
        String href = "psdFix://" + path;
        return String.format("<a href='%1$s'>%2$s</a>", href, this.myHrefText);
    }
}

