/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.ActionCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import net.jcip.annotations.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class ArtifactRepositorySearch {
    @NotNull
    private final List<ArtifactRepository> myRepositories;

    public ArtifactRepositorySearch(@NotNull List<ArtifactRepository> repositories) {
        this.myRepositories = repositories;
    }

    @NotNull
    public Callback start(@NotNull SearchRequest request) {
        Callback callback = new Callback();
        ArrayList jobs = Lists.newArrayListWithExpectedSize((int)this.myRepositories.size());
        ArrayList results = Lists.newArrayList();
        ArrayList errors = Lists.newArrayList();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            for (ArtifactRepository repository : this.myRepositories) {
                jobs.add(application.executeOnPooledThread(() -> repository.search(request)));
            }
            for (Future job : jobs) {
                try {
                    results.add(Futures.get((Future)job, Exception.class));
                }
                catch (Exception e) {
                    errors.add(e);
                }
            }
            callback.setDone(results, errors);
        });
        return callback;
    }

    public static class Callback
    extends ActionCallback {
        @NotNull
        private final List<SearchResult> mySearchResults = Lists.newArrayList();
        @NotNull
        private final List<Exception> myErrors = Lists.newArrayList();

        void setDone(@NotNull List<SearchResult> searchResults, @NotNull List<Exception> errors) {
            searchResults.forEach(searchResult -> {
                Exception error = searchResult.getError();
                if (error != null) {
                    this.myErrors.add(error);
                    return;
                }
                this.mySearchResults.add((SearchResult)searchResult);
            });
            this.myErrors.addAll(errors);
            this.setDone();
        }

        @NotNull
        public List<SearchResult> getSearchResults() {
            this.checkIsDone();
            return this.mySearchResults;
        }

        @NotNull
        public List<Exception> getErrors() {
            this.checkIsDone();
            return this.myErrors;
        }

        private void checkIsDone() {
            if (!this.isDone()) {
                throw new IllegalStateException("Repository search has not finished yet");
            }
        }
    }
}

