/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsChildModel;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModel;
import com.android.tools.idea.gradle.structure.model.android.PsVariant;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidArtifact
extends PsChildModel
implements PsAndroidModel {
    @NonNls
    private static final String COMPILE_SUFFIX = "Compile";
    @NotNull
    private final String myName;
    @NotNull
    private final String myResolvedName;
    @NotNull
    private final Icon myIcon;
    @Nullable
    private final BaseArtifact myResolvedModel;

    public PsAndroidArtifact(@NotNull PsVariant parent, @NotNull String resolvedName, @Nullable BaseArtifact resolvedModel) {
        super(parent);
        this.myResolvedName = resolvedName;
        Icon icon = AllIcons.Nodes.Artifact;
        String name = "";
        switch (resolvedName) {
            case "_main_": {
                icon = AllIcons.Modules.SourceRoot;
                break;
            }
            case "_android_test_": {
                name = "AndroidTest";
                icon = AndroidIcons.AndroidTestRoot;
                break;
            }
            case "_unit_test_": {
                name = "UnitTest";
                icon = AllIcons.Modules.TestRoot;
            }
        }
        this.myName = name;
        this.myIcon = icon;
        this.myResolvedModel = resolvedModel;
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getResolvedName() {
        return this.myResolvedName;
    }

    @Nullable
    public BaseArtifact getResolvedModel() {
        return this.myResolvedModel;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    @NotNull
    public AndroidGradleModel getGradleModel() {
        return this.getParent().getGradleModel();
    }

    @Override
    @NotNull
    public PsVariant getParent() {
        return (PsVariant)super.getParent();
    }

    @Override
    public boolean isDeclared() {
        return false;
    }

    public boolean containsAny(@NotNull Collection<DependencyModel> parsedDependencies) {
        for (DependencyModel parsedDependency : parsedDependencies) {
            if (!this.contains(parsedDependency)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(@NotNull DependencyModel parsedDependency) {
        String configurationName = parsedDependency.configurationName();
        return this.containsConfigurationName(configurationName);
    }

    public boolean containsConfigurationName(@NotNull String configurationName) {
        return this.getPossibleConfigurationNames().contains(configurationName);
    }

    @VisibleForTesting
    @NotNull
    List<String> getPossibleConfigurationNames() {
        ArrayList configurationNames = Lists.newArrayList();
        switch (this.myResolvedName) {
            case "_main_": {
                configurationNames.add("compile");
                break;
            }
            case "_unit_test_": {
                configurationNames.add("testCompile");
                break;
            }
            case "_android_test_": {
                configurationNames.add("androidTestCompile");
            }
        }
        PsVariant variant = this.getParent();
        String buildTypeName = variant.getBuildType().getName();
        switch (this.myResolvedName) {
            case "_main_": {
                configurationNames.add(buildTypeName + COMPILE_SUFFIX);
                break;
            }
            case "_unit_test_": {
                configurationNames.add("test" + StringUtil.capitalize((String)buildTypeName) + COMPILE_SUFFIX);
            }
        }
        variant.forEachProductFlavor(productFlavor -> {
            String productFlavorName = productFlavor.getName();
            switch (this.myResolvedName) {
                case "_main_": {
                    configurationNames.add(productFlavorName + COMPILE_SUFFIX);
                    break;
                }
                case "_unit_test_": {
                    configurationNames.add("test" + StringUtil.capitalize((String)productFlavorName) + COMPILE_SUFFIX);
                    break;
                }
                case "_android_test_": {
                    configurationNames.add("androidTest" + StringUtil.capitalize((String)productFlavorName) + COMPILE_SUFFIX);
                }
            }
        });
        return configurationNames;
    }
}

