/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.dependencies.android;

import com.android.tools.idea.gradle.structure.configurables.ui.PsCheckBoxList;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.model.android.PsBuildType;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

class BuildTypesPanel
extends JPanel {
    @NotNull
    private final PsCheckBoxList<PsBuildType> myBuildTypesList;
    @NotNull
    private final SelectionChangeEventDispatcher<List<PsBuildType>> myEventDispatcher = new SelectionChangeEventDispatcher();

    BuildTypesPanel(@NotNull List<PsBuildType> buildTypes) {
        super(new BorderLayout());
        ArrayList items = Lists.newArrayList(buildTypes);
        this.myBuildTypesList = new PsCheckBoxList(items);
        this.myBuildTypesList.setSelectionChangeListener(this.myEventDispatcher::selectionChanged);
        this.myBuildTypesList.setItemsSelected(true);
        new ListSpeedSearch(this.myBuildTypesList);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myBuildTypesList);
        scrollPane.setBorder(IdeBorderFactory.createBorder((int)12));
        this.add((Component)scrollPane, "Center");
    }

    @NotNull
    List<PsBuildType> getSelectedBuildTypes() {
        return this.myBuildTypesList.getSelectedItems();
    }

    void add(@NotNull SelectionChangeListener<List<PsBuildType>> listener, @NotNull Disposable parentDisposable) {
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    @NotNull
    JComponent getPreferredFocusedComponent() {
        return this.myBuildTypesList;
    }
}

