/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidModuleAnalyzer
extends PsModuleAnalyzer<PsAndroidModule> {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    public PsAndroidModuleAnalyzer(@NotNull PsContext context) {
        super(context);
    }

    @Override
    protected void doAnalyze(@NotNull PsAndroidModule module, @NotNull PsIssueCollection issueCollection) {
        ArrayListMultimap issuesByData = ArrayListMultimap.create();
        AndroidGradleModel gradleModel = module.getGradleModel();
        Collection syncIssues = gradleModel.getAndroidProject().getSyncIssues();
        for (SyncIssue syncIssue : syncIssues) {
            String data = Strings.nullToEmpty((String)syncIssue.getData());
            issuesByData.put((Object)data, (Object)syncIssue);
        }
        PsModulePath modulePath = new PsModulePath(module);
        module.forEachDependency(arg_0 -> this.lambda$doAnalyze$290((Multimap)issuesByData, modulePath, issueCollection, arg_0));
    }

    @VisibleForTesting
    @NotNull
    static PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path, @Nullable PsPath extraPath) {
        String message = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message);
        boolean result = matcher.find();
        while (result) {
            String url = matcher.group();
            message = message.replace(url, "<a href='" + url + "'>" + url + "</a>");
            result = matcher.find();
        }
        PsIssue issue = new PsIssue(message, path, PsIssueType.PROJECT_ANALYSIS, PsAndroidModuleAnalyzer.getSeverity(syncIssue));
        issue.setExtraPath(extraPath);
        return issue;
    }

    @NotNull
    private static PsIssue.Severity getSeverity(@NotNull SyncIssue issue) {
        int severity = issue.getSeverity();
        switch (severity) {
            case 2: {
                return PsIssue.Severity.ERROR;
            }
            case 1: {
                return PsIssue.Severity.WARNING;
            }
        }
        return PsIssue.Severity.INFO;
    }

    @Override
    @NotNull
    public Class<PsAndroidModule> getSupportedModelType() {
        return PsAndroidModule.class;
    }

    private /* synthetic */ void lambda$doAnalyze$290(Multimap multimap, PsModulePath psModulePath, PsIssueCollection psIssueCollection, PsAndroidDependency dependency) {
        if (dependency instanceof PsLibraryDependency && dependency.isDeclared()) {
            PsLibraryDependency libraryDependency = (PsLibraryDependency)((Object)dependency);
            PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(this.getContext(), libraryDependency);
            PsArtifactDependencySpec resolvedSpec = libraryDependency.getResolvedSpec();
            String issueKey = resolvedSpec.group + ":" + resolvedSpec.name;
            Collection librarySyncIssues = multimap.get((Object)issueKey);
            for (SyncIssue syncIssue : librarySyncIssues) {
                PsIssue issue = PsAndroidModuleAnalyzer.createIssueFrom(syncIssue, path, psModulePath);
                psIssueCollection.add(issue);
            }
            this.analyzeDeclaredDependency(libraryDependency, psModulePath, psIssueCollection);
        }
    }
}

