/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsAndroidModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsJavaModuleAnalyzer;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PsAnalyzerDaemon
extends PsDaemon {
    private static final Logger LOG = Logger.getInstance(PsAnalyzerDaemon.class);
    @NotNull
    private final MergingUpdateQueue myMainQueue;
    @NotNull
    private final MergingUpdateQueue myResultsUpdaterQueue;
    @NotNull
    private final PsIssueCollection myIssues;
    @NotNull
    private final Map<Class<?>, PsModelAnalyzer<?>> myModelAnalyzers = Maps.newHashMap();
    @NotNull
    private final AtomicBoolean myRunning = new AtomicBoolean(true);
    @NotNull
    private final EventDispatcher<IssuesUpdatedListener> myIssuesUpdatedEventDispatcher = EventDispatcher.create(IssuesUpdatedListener.class);

    public PsAnalyzerDaemon(@NotNull PsContext context, @NotNull PsLibraryUpdateCheckerDaemon libraryUpdateCheckerDaemon) {
        super(context);
        this.myMainQueue = this.createQueue("Project Structure Daemon Analyzer", null);
        this.myResultsUpdaterQueue = this.createQueue("Project Structure Analysis Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.myIssues = new PsIssueCollection(this.getContext());
        libraryUpdateCheckerDaemon.add(this::addApplicableUpdatesAsIssues, this);
        this.createModelAnalyzers();
    }

    public void recreateUpdateIssues() {
        this.removeIssues(PsIssueType.LIBRARY_UPDATES_AVAILABLE);
        this.addApplicableUpdatesAsIssues();
    }

    private void addApplicableUpdatesAsIssues() {
        PsContext context = this.getContext();
        context.getProject().forEachModule(module -> {
            Ref updatesFound = new Ref((Object)false);
            if (module instanceof PsAndroidModule) {
                PsAndroidModule androidModule = (PsAndroidModule)module;
                androidModule.forEachDeclaredDependency(dependency -> {
                    boolean found;
                    if (dependency instanceof PsLibraryDependency && (found = this.checkForUpdates((PsLibraryDependency)((Object)dependency)))) {
                        updatesFound.set((Object)true);
                    }
                });
            } else if (module instanceof PsJavaModule) {
                PsJavaModule javaModule = (PsJavaModule)module;
                javaModule.forEachDeclaredDependency(dependency -> {
                    boolean found;
                    if (dependency instanceof PsLibraryDependency && (found = this.checkForUpdates((PsLibraryDependency)((Object)dependency)))) {
                        updatesFound.set((Object)true);
                    }
                });
            }
            if (((Boolean)updatesFound.get()).booleanValue()) {
                this.myResultsUpdaterQueue.queue((Update)new IssuesComputed((PsModel)module));
            }
        });
    }

    private boolean checkForUpdates(@NotNull PsLibraryDependency dependency) {
        AvailableLibraryUpdateStorage.AvailableLibraryUpdate update;
        PsContext context = this.getContext();
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates results = context.getLibraryUpdateCheckerDaemon().getAvailableUpdates();
        PsArtifactDependencySpec spec = dependency.getDeclaredSpec();
        if (spec != null && (update = results.findUpdateFor(spec)) != null) {
            String text = String.format("Newer version available: <b>%1$s</b> (%2$s)", update.version, update.repository);
            PsLibraryDependencyNavigationPath mainPath = new PsLibraryDependencyNavigationPath(context, dependency);
            PsIssue issue = new PsIssue(text, mainPath, PsIssueType.LIBRARY_UPDATES_AVAILABLE, PsIssue.Severity.UPDATE);
            issue.setExtraPath(new PsModulePath(dependency.getParent()));
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency, update.version);
            quickFix.setHrefText("[Update]");
            issue.setQuickFixPath(quickFix);
            this.myIssues.add(issue);
            return true;
        }
        return false;
    }

    private void createModelAnalyzers() {
        this.add(new PsAndroidModuleAnalyzer(this.getContext()));
        this.add(new PsJavaModuleAnalyzer(this.getContext()));
    }

    private void add(@NotNull PsModelAnalyzer<? extends PsModel> analyzer) {
        this.myModelAnalyzers.put(analyzer.getSupportedModelType(), analyzer);
    }

    public void add(@NotNull IssuesUpdatedListener listener, @NotNull Disposable parentDisposable) {
        this.myIssuesUpdatedEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.myRunning.get();
    }

    public void queueCheck(@NotNull PsModel model) {
        this.myMainQueue.queue((Update)new AnalyzeStructure(model));
    }

    private void doCheck(final @NotNull PsModel model) {
        this.myRunning.set(true);
        final PsModelAnalyzer<?> analyzer = this.myModelAnalyzers.get(model.getClass());
        if (analyzer == null) {
            LOG.info("Failed to find analyzer for model of type " + model.getClass().getName());
            return;
        }
        RunResult result = new ReadAction<ActionCallback>(){

            protected void run(@NotNull Result<ActionCallback> result) throws Throwable {
                if (PsAnalyzerDaemon.this.isStopped()) {
                    return;
                }
                analyzer.analyze(model, PsAnalyzerDaemon.this.myIssues);
                result.setResult((Object)ActionCallback.DONE);
            }
        }.execute();
        ((ActionCallback)result.getResultObject()).doWhenDone(() -> this.myResultsUpdaterQueue.queue((Update)new IssuesComputed(model)));
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.myMainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.myResultsUpdaterQueue;
    }

    @NotNull
    public PsIssueCollection getIssues() {
        return this.myIssues;
    }

    public void removeIssues(@NotNull PsIssueType type) {
        this.myIssues.remove(type);
        this.myResultsUpdaterQueue.queue((Update)new IssuesComputed(this.getContext().getProject()));
    }

    public static interface IssuesUpdatedListener
    extends EventListener {
        public void issuesUpdated(@NotNull PsModel var1);
    }

    private class IssuesComputed
    extends Update {
        @NotNull
        private final PsModel myModel;

        public IssuesComputed(PsModel model) {
            super((Object)model);
            this.myModel = model;
        }

        public void run() {
            if (PsAnalyzerDaemon.this.isStopped()) {
                PsAnalyzerDaemon.this.myRunning.set(false);
                return;
            }
            ((IssuesUpdatedListener)PsAnalyzerDaemon.this.myIssuesUpdatedEventDispatcher.getMulticaster()).issuesUpdated(this.myModel);
            PsAnalyzerDaemon.this.myRunning.set(false);
        }
    }

    private class AnalyzeStructure
    extends Update {
        @NotNull
        private final PsModel myModel;

        AnalyzeStructure(PsModel model) {
            super((Object)model);
            this.myModel = model;
        }

        public void run() {
            try {
                PsAnalyzerDaemon.this.doCheck(this.myModel);
            }
            catch (Throwable e) {
                LOG.error("Failed to analyze " + this.myModel, e);
            }
        }
    }
}

