/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AvailableLibraryUpdateStorage", storages={@Storage(value="$WORKSPACE_FILE$")})
public class AvailableLibraryUpdateStorage
implements PersistentStateComponent<AvailableLibraryUpdates> {
    @NotNull
    public AvailableLibraryUpdates state = new AvailableLibraryUpdates();

    @NotNull
    public static AvailableLibraryUpdateStorage getInstance(Project project) {
        return (AvailableLibraryUpdateStorage)ServiceManager.getService((Project)project, AvailableLibraryUpdateStorage.class);
    }

    @NotNull
    public AvailableLibraryUpdates getState() {
        return this.state;
    }

    public void loadState(AvailableLibraryUpdates state) {
        this.state = state;
        this.state.index();
    }

    @Tag(value="library-update")
    public static class AvailableLibraryUpdate {
        @Tag(value="group-id")
        public String groupId;
        @Tag(value="name")
        public String name;
        @Tag(value="version")
        public String version;
        @Tag(value="repository")
        public String repository;
    }

    public static class AvailableLibraryUpdates {
        @Tag(value="library-updates")
        @AbstractCollection(surroundWithTag=false)
        @NotNull
        public List<AvailableLibraryUpdate> updates = Lists.newArrayList();
        @Tag(value="last-search-timestamp")
        public long lastSearchTimeMillis = -1L;
        @Transient
        @NotNull
        private final Map<LibraryUpdateId, AvailableLibraryUpdate> myUpdatesById = Maps.newHashMap();

        public void clear() {
            this.updates.clear();
            this.myUpdatesById.clear();
        }

        void index() {
            this.myUpdatesById.clear();
            this.updates.forEach(this::index);
        }

        public void add(@NotNull FoundArtifact artifact) {
            AvailableLibraryUpdate update = new AvailableLibraryUpdate();
            update.groupId = artifact.getGroupId();
            update.name = artifact.getName();
            update.version = artifact.getVersions().get(0).toString();
            update.repository = artifact.getRepositoryName();
            this.updates.add(update);
            this.index(update);
        }

        private void index(@NotNull AvailableLibraryUpdate update) {
            this.myUpdatesById.put(new LibraryUpdateId(update.name, update.groupId), update);
        }

        @Nullable
        public AvailableLibraryUpdate findUpdateFor(@NotNull PsArtifactDependencySpec spec) {
            GradleVersion foundVersion;
            LibraryUpdateId id;
            AvailableLibraryUpdate update;
            GradleVersion parsedVersion;
            String version = spec.version;
            if (StringUtil.isNotEmpty((String)version) && (parsedVersion = GradleVersion.tryParse((String)spec.version)) != null && (update = this.myUpdatesById.get(id = new LibraryUpdateId(spec.name, spec.group))) != null && (foundVersion = GradleVersion.parse((String)update.version)).compareTo(parsedVersion) > 0) {
                return update;
            }
            return null;
        }
    }
}

