/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.DependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.ChooseModuleDialog;
import com.android.tools.idea.gradle.structure.configurables.ui.EmptyPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.DependencyInfoPanel;
import com.android.tools.idea.gradle.structure.dependencies.AddLibraryDependencyDialog;
import com.android.tools.idea.gradle.structure.dependencies.AddModuleDependencyDialog;
import com.android.tools.idea.gradle.structure.model.PsBaseDependency;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.structure.dialog.Header;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependenciesPanel
extends JPanel
implements Place.Navigator,
Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final EmptyPanel myEmptyDetailsPanel;
    @NotNull
    private final DependencyInfoPanel myInfoPanel;
    @NotNull
    private final JScrollPane myInfoScrollPane;
    @NotNull
    private final Header myHeader;
    @NotNull
    private final JPanel myContentsPanel;
    @NotNull
    private final String myEmptyText;
    @NotNull
    private final List<DependencyDetails> myDependencyDetails = Lists.newArrayList();
    @Nullable
    private final PsModule myModule;
    private DependencyDetails myCurrentDependencyDetails;
    private History myHistory;
    private IssuesViewer myIssuesViewer;
    private AddLibraryDependencyAction myAddLibraryDependencyAction;

    protected AbstractDependenciesPanel(@NotNull String title, @NotNull PsContext context, @Nullable PsModule module) {
        super(new BorderLayout());
        this.myContext = context;
        this.myModule = module;
        this.myEmptyText = String.format("Please select a dependency from the '%1$s' view", title);
        this.myEmptyDetailsPanel = new EmptyPanel(this.myEmptyText);
        this.myInfoPanel = new DependencyInfoPanel();
        this.myInfoScrollPane = ScrollPaneFactory.createScrollPane((Component)this.myEmptyDetailsPanel, (int)20, (int)31);
        this.myInfoScrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        this.myHeader = new Header(title);
        this.add((Component)this.myHeader, "North");
        JBSplitter splitter = new JBSplitter(true, "psd.editable.dependencies.main.horizontal.splitter.proportion", 0.55f);
        this.myContentsPanel = new JPanel(new BorderLayout());
        this.myContentsPanel.setBorder((Border)new SideBorder(OnePixelDivider.BACKGROUND, 8));
        splitter.setFirstComponent((JComponent)this.myContentsPanel);
        splitter.setSecondComponent((JComponent)this.myInfoScrollPane);
        this.add((Component)splitter, "Center");
    }

    @NotNull
    public abstract JComponent getPreferredFocusedComponent();

    protected void addDetails(@NotNull DependencyDetails details) {
        this.myDependencyDetails.add(details);
    }

    protected void setIssuesViewer(@NotNull IssuesViewer issuesViewer) {
        this.myIssuesViewer = issuesViewer;
        this.myIssuesViewer.setShowEmptyText(false);
        this.myInfoPanel.setIssuesViewer(this.myIssuesViewer);
    }

    protected void displayIssues(@NotNull Collection<PsIssue> issues) {
        assert (this.myIssuesViewer != null);
        this.myIssuesViewer.display(issues);
        this.myInfoPanel.revalidateAndRepaintPanel();
        ApplicationManager.getApplication().invokeLater(() -> this.myInfoScrollPane.getVerticalScrollBar().setValue(0));
    }

    protected void updateDetails(@Nullable PsDependency selected) {
        String scope = selected != null ? selected.getJoinedConfigurationNames() : null;
        this.updateDetails(selected, scope);
    }

    protected void updateDetails(@Nullable PsDependency selected, @Nullable String configurationNames) {
        if (selected != null) {
            this.myCurrentDependencyDetails = this.findDetails(selected);
            if (this.myCurrentDependencyDetails != null) {
                this.myInfoPanel.setDependencyDetails(this.myCurrentDependencyDetails);
                this.myInfoScrollPane.setViewportView(this.myInfoPanel.getPanel());
                this.myCurrentDependencyDetails.display(selected, configurationNames);
                return;
            }
        }
        this.myCurrentDependencyDetails = null;
        this.myInfoScrollPane.setViewportView(this.myEmptyDetailsPanel);
    }

    @Nullable
    private DependencyDetails findDetails(@NotNull PsDependency selected) {
        for (DependencyDetails details : this.myDependencyDetails) {
            if (!details.getSupportedModelType().isInstance(selected)) continue;
            return details;
        }
        return null;
    }

    @Nullable
    protected DependencyDetails getCurrentDependencyDetails() {
        return this.myCurrentDependencyDetails;
    }

    @NotNull
    protected final JPanel createActionsPanel() {
        final JPanel actionsPanel = new JPanel(new BorderLayout());
        DefaultActionGroup actions = new DefaultActionGroup();
        DumbAwareAction addDependencyAction = new DumbAwareAction("Add Dependency", "", IconUtil.getAddIcon()){

            public void actionPerformed(AnActionEvent e) {
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AbstractPopupAction>(null, AbstractDependenciesPanel.this.getPopupActions()){

                    public Icon getIconFor(AbstractPopupAction action) {
                        return action.icon;
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep onChosen(AbstractPopupAction action, boolean finalChoice) {
                        return this.doFinalStep(action::execute);
                    }

                    @NotNull
                    public String getTextFor(AbstractPopupAction action) {
                        return "&" + action.index + "  " + action.text;
                    }
                });
                popup.show(new RelativePoint((Component)actionsPanel, new Point(0, actionsPanel.getHeight() - 1)));
            }
        };
        actions.add((AnAction)addDependencyAction);
        List<AnAction> extraToolbarActions = this.getExtraToolbarActions();
        if (!extraToolbarActions.isEmpty()) {
            actions.addSeparator();
            actions.addAll(extraToolbarActions);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TOP", (ActionGroup)actions, true);
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        actionsPanel.add((Component)toolbarComponent, "Center");
        return actionsPanel;
    }

    @NotNull
    protected List<AnAction> getExtraToolbarActions() {
        return Collections.emptyList();
    }

    @NotNull
    private List<AbstractPopupAction> getPopupActions() {
        if (this.myAddLibraryDependencyAction == null) {
            this.myAddLibraryDependencyAction = new AddLibraryDependencyAction();
        }
        ArrayList actions = Lists.newArrayList((Object[])new AbstractPopupAction[]{this.myAddLibraryDependencyAction});
        PsProject project = this.myContext.getProject();
        if (project.getModelCount() > 1) {
            actions.add(new AddModuleDependencyAction());
        }
        return actions;
    }

    @NotNull
    protected JPanel getContentsPanel() {
        return this.myContentsPanel;
    }

    @NotNull
    protected PsContext getContext() {
        return this.myContext;
    }

    @NotNull
    public Header getHeader() {
        return this.myHeader;
    }

    @NotNull
    public String getEmptyText() {
        return this.myEmptyText;
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }

    public void queryPlace(@NotNull Place place) {
        PsBaseDependency model;
        String dependency = "";
        DependencyDetails details = this.getCurrentDependencyDetails();
        if (details != null && (model = details.getModel()) != null) {
            dependency = model.toText(PsDependency.TextType.FOR_NAVIGATION);
        }
        this.putPath(place, dependency);
    }

    public void putPath(@NotNull Place place, @NotNull String dependency) {
        place.putPath(this.getPlaceName(), (Object)dependency);
    }

    @NotNull
    protected abstract String getPlaceName();

    public abstract void selectDependency(@Nullable String var1);

    private static abstract class AbstractPopupAction
    implements ActionListener {
        @NotNull
        final String text;
        @NotNull
        final Icon icon;
        final int index;

        AbstractPopupAction(@NotNull String text, @NotNull Icon icon, int index) {
            this.text = text;
            this.icon = icon;
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.execute();
        }

        abstract void execute();
    }

    private abstract class AbstractAddDependencyAction
    extends AbstractPopupAction {
        @NotNull
        private final String myTitle;

        AbstractAddDependencyAction(@NotNull String title, @NotNull String text, Icon icon, int index) {
            super(text, icon, index);
            this.myTitle = title;
        }

        @Override
        void execute() {
            if (AbstractDependenciesPanel.this.myModule == null) {
                PsProject project = AbstractDependenciesPanel.this.myContext.getProject();
                int modelCount = project.getModelCount();
                if (modelCount == 1) {
                    Ref moduleRef = new Ref();
                    project.forEachModule(arg_0 -> ((Ref)moduleRef).set(arg_0));
                    PsModule module = (PsModule)moduleRef.get();
                    assert (module != null);
                    this.showAddDependencyDialog(module);
                    return;
                }
                Consumer<PsModule> onOkTask = this::showAddDependencyDialog;
                ChooseModuleDialog dialog = new ChooseModuleDialog(project, onOkTask, this.myTitle);
                dialog.showAndGet();
                return;
            }
            this.showAddDependencyDialog(AbstractDependenciesPanel.this.myModule);
        }

        protected abstract void showAddDependencyDialog(@NotNull PsModule var1);
    }

    private class AddModuleDependencyAction
    extends AbstractAddDependencyAction {
        AddModuleDependencyAction() {
            super("Add Module Dependency", "Module Dependency", AllIcons.Nodes.Module, 2);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddModuleDependencyDialog dialog = new AddModuleDependencyDialog(module);
            if (dialog.showAndGet()) {
                dialog.addNewDependencies();
            }
        }
    }

    private class AddLibraryDependencyAction
    extends AbstractAddDependencyAction {
        AddLibraryDependencyAction() {
            super("Add Library Dependency", "Library Dependency", PlatformIcons.LIBRARY_ICON, 1);
        }

        @Override
        protected void showAddDependencyDialog(@NotNull PsModule module) {
            AddLibraryDependencyDialog dialog = new AddLibraryDependencyDialog(module);
            if (dialog.showAndGet()) {
                dialog.addNewDependencies();
            }
        }
    }
}

