/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.configurables.ui.AbstractPsModelTableCellRenderer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDeclaredDependenciesTableModel<T extends PsDependency>
extends ListTableModel<T> {
    @NotNull
    private final PsModule myModule;
    @NotNull
    private final PsContext myContext;
    @Nullable
    private PsModuleDependency myHoveredDependency;

    protected AbstractDeclaredDependenciesTableModel(@NotNull PsModule module, @NotNull PsContext context) {
        super(new ColumnInfo[0]);
        this.myModule = module;
        this.myContext = context;
        this.createAndSetColumnInfos();
        this.reset();
    }

    private void createAndSetColumnInfos() {
        ColumnInfo specColumnInfo = new ColumnInfo<T, String>("Dependency"){

            @NotNull
            public String valueOf(T dependency) {
                return dependency.toText(PsDependency.TextType.PLAIN_TEXT);
            }

            @NotNull
            public TableCellRenderer getRenderer(T dependency) {
                return new DependencyCellRenderer((PsDependency)dependency, AbstractDeclaredDependenciesTableModel.this.myContext, dependency == AbstractDeclaredDependenciesTableModel.this.myHoveredDependency);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "com.android.support:appcompat-v7:23.1.0";
            }
        };
        ColumnInfo scopeColumnInfo = new ColumnInfo<T, String>("Scope"){

            @Nullable
            public String valueOf(T dependency) {
                return ((PsDependency)dependency).getJoinedConfigurationNames();
            }

            @NotNull
            public String getPreferredStringValue() {
                return "flavor1AndroidTestCompile";
            }
        };
        this.setColumnInfos(new ColumnInfo[]{specColumnInfo, scopeColumnInfo});
    }

    @NotNull
    protected PsModule getModule() {
        return this.myModule;
    }

    public void setHoveredDependency(@Nullable PsModuleDependency hoveredDependency) {
        this.myHoveredDependency = hoveredDependency;
    }

    public void reset() {
    }

    @Nullable
    public PsLibraryDependency findDependency(@NotNull PsArtifactDependencySpec spec) {
        for (PsDependency dependency : this.getItems()) {
            PsLibraryDependency libraryDependency;
            if (!(dependency instanceof PsLibraryDependency) || !spec.equals((libraryDependency = (PsLibraryDependency)((Object)dependency)).getDeclaredSpec())) continue;
            return libraryDependency;
        }
        return null;
    }

    @NotNull
    static String displayTextOf(@NotNull PsDependency dependency) {
        String text = dependency.toText(PsDependency.TextType.PLAIN_TEXT);
        if (dependency instanceof PsLibraryDependency) {
            PsLibraryDependency library = (PsLibraryDependency)((Object)dependency);
            PsArtifactDependencySpec spec = library.getDeclaredSpec();
            assert (spec != null);
            text = spec.getDisplayText();
        }
        return text;
    }

    static class DependencyCellRenderer
    extends AbstractPsModelTableCellRenderer<PsDependency> {
        @NotNull
        private final PsDependency myDependency;
        @NotNull
        private final PsContext myContext;
        private final boolean myIsHovered;

        DependencyCellRenderer(@NotNull PsDependency dependency, @NotNull PsContext context, boolean isHovered) {
            super(dependency);
            this.myDependency = dependency;
            this.myContext = context;
            this.myIsHovered = isHovered;
        }

        @Override
        protected void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            SimpleTextAttributes textAttributes;
            this.setIcon(this.myDependency.getIcon());
            this.setIconOpaque(true);
            this.setFocusBorderAroundIcon(true);
            PsIssueCollection issueCollection = this.myContext.getAnalyzerDaemon().getIssues();
            List<PsIssue> issues = issueCollection.findIssues(this.myDependency, (Comparator<PsIssue>)IssuesByTypeAndTextComparator.INSTANCE);
            this.setToolTipText(PsIssueCollection.getTooltipText(issues, false));
            if (this.myIsHovered) {
                textAttributes = SimpleTextAttributes.LINK_ATTRIBUTES;
            } else {
                textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (!issues.isEmpty()) {
                    PsIssue issue = issues.get(0);
                    Color waveColor = issue.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
            }
            this.append(this.getText(), textAttributes);
        }

        @Override
        @NotNull
        protected String getText() {
            return AbstractDeclaredDependenciesTableModel.displayTextOf((PsDependency)this.getModel());
        }
    }
}

