/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview;

import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.google.common.collect.Lists;
import com.intellij.ui.treeStructure.SimpleNode;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleDependencyNode
extends AbstractDependencyNode<PsModuleAndroidDependency> {
    private final List<AbstractPsModelNode<?>> myChildren = Lists.newArrayList();

    public ModuleDependencyNode(@NotNull AbstractPsNode parent, @NotNull PsModuleAndroidDependency dependency) {
        super(parent, dependency);
        this.setUp(dependency);
    }

    public ModuleDependencyNode(@NotNull AbstractPsNode parent, @NotNull List<PsModuleAndroidDependency> dependencies) {
        super(parent, dependencies);
        this.setUp(dependencies.get(0));
    }

    private void setUp(@NotNull PsModuleAndroidDependency moduleDependency) {
        this.myName = moduleDependency.toText(PsDependency.TextType.PLAIN_TEXT);
        PsAndroidModule dependentModule = moduleDependency.getParent();
        PsProject project = dependentModule.getParent();
        PsModule referred = project.findModuleByGradlePath(moduleDependency.getGradlePath());
        if (referred instanceof PsAndroidModule) {
            PsAndroidModule androidModule = (PsAndroidModule)referred;
            androidModule.forEachDependency(dependency -> {
                if (!dependency.isDeclared()) {
                    return;
                }
                String moduleVariant = moduleDependency.getConfigurationName();
                if (!dependency.isIn("_main_", moduleVariant)) {
                    return;
                }
                AbstractDependencyNode<?> child = AbstractDependencyNode.createNode(this, dependency);
                if (child != null) {
                    this.myChildren.add(child);
                }
            });
        }
    }

    @NotNull
    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
    }
}

