/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.DependencySelection;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.treeview.ResolvedDependenciesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractPsNodeTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.SelectNodesMatchingCurrentSelectionAction;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseExpandAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvedDependenciesPanel
extends ToolWindowPanel
implements DependencySelection {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final ResolvedDependenciesTreeBuilder myTreeBuilder;
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<PsAndroidDependency> myEventDispatcher = new SelectionChangeEventDispatcher();
    private boolean myIgnoreTreeSelectionEvents;

    public ResolvedDependenciesPanel(@NotNull PsAndroidModule module, @NotNull PsContext context, @NotNull DependencySelection dependencySelection) {
        this("Resolved Dependencies", module, context, dependencySelection, ToolWindowAnchor.RIGHT);
    }

    public ResolvedDependenciesPanel(@NotNull String title, @NotNull PsAndroidModule module, @NotNull PsContext context, @NotNull DependencySelection dependencySelection, @Nullable ToolWindowAnchor anchor) {
        super(title, AndroidIcons.Variant, anchor);
        this.myContext = context;
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id = e.getID();
                if (id == 501 && (node = (ModuleDependencyNode)((Object)ResolvedDependenciesPanel.this.myHyperlinkSupport.getIfHyperlink(e))) != null) {
                    PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getModels().get(0);
                    String name = moduleDependency.getName();
                    ResolvedDependenciesPanel.this.myContext.setSelectedModule(name, ResolvedDependenciesPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.setHeaderActions();
        this.getHeader().setPreferredFocusedComponent((JComponent)this.myTree);
        this.myTreeBuilder = new ResolvedDependenciesTreeBuilder(module, (JTree)this.myTree, treeModel, dependencySelection, this);
        module.add((PsModule.DependencyChangedEvent event) -> this.myTreeBuilder.reset(), this);
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder);
        this.add((Component)scrollPane, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            if (this.myIgnoreTreeSelectionEvents) {
                return;
            }
            PsAndroidDependency selected = this.getSelection();
            if (selected == null) {
                AbstractPsModelNode selectedNode = this.getSelectionIfSingle();
                if (selectedNode != null && !(selectedNode instanceof AbstractDependencyNode)) {
                    this.notifySelectionChanged(null);
                }
            } else {
                this.notifySelectionChanged(selected);
            }
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ResolvedDependenciesPanel.this.popupInvoked(x, y);
            }
        });
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, false);
    }

    private void notifySelectionChanged(@Nullable PsAndroidDependency selected) {
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void setHeaderActions() {
        ArrayList additionalActions = Lists.newArrayList();
        additionalActions.add(new SelectNodesMatchingCurrentSelectionAction(){

            @Override
            @NotNull
            protected AbstractPsNodeTreeBuilder getTreeBuilder() {
                return ResolvedDependenciesPanel.this.myTreeBuilder;
            }
        });
        additionalActions.add(Separator.getInstance());
        additionalActions.add(new AbstractBaseExpandAllAction(this.myTree){

            public void actionPerformed(AnActionEvent e) {
                ResolvedDependenciesPanel.this.myIgnoreTreeSelectionEvents = true;
                ResolvedDependenciesPanel.this.myTree.requestFocusInWindow();
                ResolvedDependenciesPanel.this.myTreeBuilder.expandAllNodes();
                ResolvedDependenciesPanel.this.myIgnoreTreeSelectionEvents = false;
            }
        });
        additionalActions.add(new AbstractBaseCollapseAllAction(this.myTree){

            public void actionPerformed(AnActionEvent e) {
                ResolvedDependenciesPanel.this.collapseAllNodes();
            }
        });
        additionalActions.add(Separator.getInstance());
        this.getHeader().setAdditionalActions(additionalActions);
    }

    private void collapseAllNodes() {
        this.myTree.requestFocusInWindow();
        this.myIgnoreTreeSelectionEvents = true;
        this.myTreeBuilder.collapseAllNodes();
        this.myIgnoreTreeSelectionEvents = false;
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getModels().get(0);
            String name = moduleDependency.getName();
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new GoToModuleAction(name, this.myContext, (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    @Override
    public void setSelection(@Nullable PsAndroidDependency selection) {
        if (selection == null) {
            this.myTreeBuilder.clearSelection();
        } else {
            this.myIgnoreTreeSelectionEvents = true;
            this.myTreeBuilder.selectMatchingNodes(selection, true);
            this.myIgnoreTreeSelectionEvents = false;
        }
    }

    public void add(@NotNull SelectionChangeListener<PsAndroidDependency> listener) {
        this.myEventDispatcher.addListener(listener, this);
    }

    @Override
    @Nullable
    public PsAndroidDependency getSelection() {
        AbstractDependencyNode node;
        List models;
        AbstractPsModelNode selection = this.getSelectionIfSingle();
        if (selection instanceof AbstractDependencyNode && !(models = (node = (AbstractDependencyNode)selection).getModels()).isEmpty()) {
            return (PsAndroidDependency)models.get(0);
        }
        return null;
    }

    @Nullable
    private AbstractPsModelNode getSelectionIfSingle() {
        Set selection = this.myTreeBuilder.getSelectedElements(AbstractPsModelNode.class);
        if (selection.size() == 1) {
            return (AbstractPsModelNode)((Object)ContainerUtil.getFirstItem((Collection)selection));
        }
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }
}

