/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.structure.configurables.AbstractDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.BasePerspectiveConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.PsAllModulesFakeModule;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.AndroidModuleDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.project.ProjectDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.configurables.java.dependencies.JavaModuleDependenciesConfigurable;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.java.PsJavaModule;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.ui.NamedConfigurable;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesPerspectiveConfigurable
extends BasePerspectiveConfigurable {
    @NotNull
    private final Map<String, AbstractDependenciesConfigurable<? extends PsModule>> myConfigurablesByGradlePath = Maps.newHashMap();
    @NotNull
    private final List<PsModule> myExtraTopModules = Lists.newArrayListWithExpectedSize((int)2);
    @NotNull
    private final Map<PsModule, AbstractDependenciesConfigurable<? extends PsModule>> myExtraTopConfigurables = Maps.newHashMapWithExpectedSize((int)2);

    public DependenciesPerspectiveConfigurable(@NotNull PsContext context) {
        super(context);
    }

    @Override
    @Nullable
    protected NamedConfigurable<? extends PsModule> getConfigurable(@NotNull PsModule module) {
        AbstractDependenciesConfigurable configurable;
        if (module instanceof PsAllModulesFakeModule) {
            configurable = this.myExtraTopConfigurables.get(module);
            if (configurable == null) {
                configurable = new ProjectDependenciesConfigurable(module, this.getContext(), this.getExtraTopModules());
                ((BaseNamedConfigurable)configurable).setHistory(this.myHistory);
                this.myExtraTopConfigurables.put(module, configurable);
            }
        } else {
            String gradlePath = module.getGradlePath();
            configurable = this.myConfigurablesByGradlePath.get(gradlePath);
            if (configurable == null) {
                if (module instanceof PsAndroidModule) {
                    PsAndroidModule androidModule = (PsAndroidModule)module;
                    configurable = new AndroidModuleDependenciesConfigurable(androidModule, this.getContext(), this.getExtraTopModules());
                    ((BaseNamedConfigurable)configurable).setHistory(this.myHistory);
                    this.myConfigurablesByGradlePath.put(gradlePath, configurable);
                } else if (module instanceof PsJavaModule) {
                    PsJavaModule javaModule = (PsJavaModule)module;
                    configurable = new JavaModuleDependenciesConfigurable(javaModule, this.getContext(), this.getExtraTopModules());
                }
            }
        }
        return configurable;
    }

    @Override
    @NotNull
    protected List<PsModule> getExtraTopModules() {
        if (this.myExtraTopModules.isEmpty()) {
            PsProject project = this.getContext().getProject();
            this.myExtraTopModules.add(new PsAllModulesFakeModule(project));
        }
        return this.myExtraTopModules;
    }

    @Override
    @NotNull
    protected String getNavigationPathName() {
        return "dependencies.place";
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myConfigurablesByGradlePath.clear();
    }

    @NotNull
    public String getId() {
        return "android.psd.dependencies";
    }

    @Nls
    public String getDisplayName() {
        return "Dependencies";
    }
}

