/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNamedConfigurable<T extends PsModule>
extends NamedConfigurable<T>
implements SearchableConfigurable,
Place.Navigator {
    @NotNull
    private final T myModule;
    private String myDisplayName;
    private History myHistory;

    protected BaseNamedConfigurable(@NotNull T module) {
        this.myModule = module;
        this.myDisplayName = ((PsModule)module).getName();
    }

    @NotNull
    protected T getModule() {
        return this.myModule;
    }

    public boolean isModified() {
        return ((PsModel)this.myModule).isModified();
    }

    public void apply() throws ConfigurationException {
        GradleBuildModel parsedModel;
        if (((PsModel)this.myModule).isModified() && (parsedModel = ((PsModule)this.myModule).getParsedModel()) != null && parsedModel.isModified()) {
            String name = String.format("Applying changes to module '%1$s'", ((PsModule)this.myModule).getName());
            new WriteCommandAction(((PsModule)this.myModule).getParent().getResolvedModel(), name, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    parsedModel.applyChanges();
                    BaseNamedConfigurable.this.myModule.setModified(false);
                }
            }.execute();
        }
    }

    public void reset() {
    }

    @Nullable
    public Icon getIcon(boolean expanded) {
        return ((PsModule)this.myModule).getIcon();
    }

    @Nls
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void setDisplayName(String name) {
        this.myDisplayName = name;
    }

    public T getEditableObject() {
        return this.myModule;
    }

    public String getBannerSlogan() {
        return "Module '" + this.myDisplayName + "'";
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    @Nullable
    protected History getHistory() {
        return this.myHistory;
    }

    public void putNavigationPath(@NotNull Place place, @NotNull String value) {
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }
}

