/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

public class FastGradleSync {
    @NotNull
    private final GradleProjectResolver myProjectResolver = new GradleProjectResolver();

    @NotNull
    public Callback requestProjectSync(@NotNull Project project) {
        Projects.setSkipSyncIssueReporting(project, true);
        Callback callback = new Callback();
        GradleExecutionSettings settings = GradleUtil.getGradleExecutionSettings(project);
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)project);
        String projectPath = project.getBasePath();
        assert (projectPath != null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                DataNode projectDataNode = this.myProjectResolver.resolveProjectInfo(id, projectPath, false, settings, ExternalSystemTaskNotificationListenerAdapter.NULL_OBJECT);
                assert (projectDataNode != null);
                UIUtil.invokeAndWaitIfNeeded(() -> Projects.populate(project, (DataNode<ProjectData>)projectDataNode, false, false));
                callback.setDone();
            }
            catch (Throwable e) {
                callback.setRejected(e);
            }
            finally {
                Projects.setSkipSyncIssueReporting(project, null);
            }
        });
        return callback;
    }

    public static class Callback
    extends ActionCallback {
        @Nullable
        private Throwable myFailure;

        void setRejected(@Nullable Throwable failure) {
            this.myFailure = failure;
            this.myError = failure != null ? failure.getMessage() : null;
            this.setRejected();
        }

        @Nullable
        public Throwable getFailure() {
            return this.myFailure;
        }
    }
}

