/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.hyperlink;

import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class ToggleOfflineModeHyperlink
extends NotificationHyperlink {
    private final boolean myEnableOfflineMode;

    @Nullable
    public static ToggleOfflineModeHyperlink enableOfflineMode(@NotNull Project project) {
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(true);
    }

    @Nullable
    public static ToggleOfflineModeHyperlink disableOfflineMode(@NotNull Project project) {
        GradleSettings settings = GradleSettings.getInstance((Project)project);
        return !settings.isOfflineWork() ? null : new ToggleOfflineModeHyperlink(false);
    }

    private ToggleOfflineModeHyperlink(boolean enableOfflineMode) {
        super("toggle.offline.mode", ToggleOfflineModeHyperlink.getText(enableOfflineMode));
        this.myEnableOfflineMode = enableOfflineMode;
    }

    @NotNull
    private static String getText(boolean enableOfflineMode) {
        String msg = enableOfflineMode ? "Enable" : "Disable";
        return msg + " Gradle 'offline mode' and sync project";
    }

    @Override
    protected void execute(@NotNull Project project) {
        GradleSettings.getInstance((Project)project).setOfflineWork(this.myEnableOfflineMode);
        GradleProjectImporter.getInstance().requestProjectSync(project, null);
    }
}

